/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.bitbucket.task.TaskAnchorType;
import com.atlassian.fugue.Effect;
import com.atlassian.stash.internal.comment.InternalComment;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;

class TaskDaoUtils {
    TaskDaoUtils() {
    }

    public static <T> void executeAsBatch(@Nonnull Iterable<T> iterable, int batchSize, @Nonnull Effect<Iterable<T>> f) {
        for (Iterable batch : Iterables.partition(iterable, (int)batchSize)) {
            f.apply((Object)batch);
        }
    }

    public static String convertToClassName(TaskAnchorType anchorType) {
        switch (anchorType) {
            case COMMENT: {
                return InternalComment.class.getName();
            }
        }
        throw new IllegalStateException("Unsupported TaskAnchorType: " + anchorType);
    }
}

