/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestCountQueryHelper;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.atlassian.stash.internal.pull.PullRequestSearchQueryHelper;
import com.atlassian.stash.internal.repository.RepositoryScopedIdGenerator;
import com.atlassian.stash.internal.task.TaskDao;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestDao")
public class HibernatePullRequestDao
extends AbstractHibernateDao<Long, InternalPullRequest>
implements PullRequestDao {
    private final PullRequestActivityDao activityDao;
    private final RepositoryScopedIdGenerator idGenerator;
    private final TaskDao taskDao;

    @Autowired
    public HibernatePullRequestDao(SessionFactory sessionFactory, PullRequestActivityDao activityDao, RepositoryScopedIdGenerator idGenerator, TaskDao taskDao) {
        super(sessionFactory);
        this.activityDao = activityDao;
        this.idGenerator = idGenerator;
        this.taskDao = taskDao;
    }

    public Map<PullRequestState, Long> countAllByStatus() {
        List results = this.session().createQuery("select state, count(*) from InternalPullRequest group by state").list();
        return this.countByState(results);
    }

    public long countMatching(@Nonnull PullRequestSearchCriteria searchCriteria) {
        return (Long)new PullRequestCountQueryHelper(searchCriteria).build(this.session()).setCacheable(true).setCacheRegion("query.pullRequestCountByUser").uniqueResult();
    }

    @Override
    public InternalPullRequest create(InternalPullRequest entity) {
        if (entity.getScopedId() == 0L) {
            long scopedId = this.idGenerator.nextId(entity.getScopeRepository().getId(), entity.getScope());
            entity.setScopedId(scopedId);
        }
        return super.create(entity);
    }

    public int declineByFromRepository(int repositoryId) {
        return this.session().createQuery("update InternalPullRequest set state = :declined where fromRef.repository.id = :repoId and state = :open").setInteger("repoId", repositoryId).setParameter("declined", (Object)PullRequestState.DECLINED).setParameter("open", (Object)PullRequestState.OPEN).executeUpdate();
    }

    @Override
    public void delete(InternalPullRequest entity) {
        long globalId = entity.getGlobalId();
        Session session = this.session();
        this.taskDao.deleteForContexts((Iterable)ImmutableList.of((Object)entity));
        session.createQuery("delete from InternalWatcher where watchable.id = :prId and watchable.class = :typeId").setLong("prId", globalId).setInteger("typeId", 1).executeUpdate();
        List commentIds = session.createQuery("select distinct comment.id from InternalPullRequestCommentActivity where pullRequest.id = :prId").setLong("prId", globalId).list();
        this.activityDao.deleteByPullRequest(globalId);
        this.deleteComments(commentIds);
        session.flush();
        super.delete(entity);
    }

    public int deleteByToRepository(int repositoryId) {
        Session session = this.session();
        this.deleteTasksByScopeRepository(repositoryId);
        session.createQuery("delete from InternalWatcher where watchable.id in (select id from InternalPullRequest where toRef.repository.id = :repoId) and watchable.class = :typeId").setInteger("repoId", repositoryId).setInteger("typeId", 1).executeUpdate();
        List commentIds = session.createQuery("select distinct comment.id from InternalPullRequestCommentActivity where pullRequest.toRef.repository.id = :repoId order by comment.id desc").setInteger("repoId", repositoryId).list();
        this.activityDao.deleteByRepository(repositoryId);
        this.deleteComments(commentIds);
        int updated = session.createQuery("delete from InternalPullRequest where toRef.repository.id = :repoId").setInteger("repoId", repositoryId).executeUpdate();
        session.flush();
        return updated;
    }

    public InternalPullRequest findByComment(long commentId) {
        Query query = this.session().createQuery("select a.pullRequest from InternalPullRequestCommentActivity a where a.comment.id = :commentId and a.commentAction in (:actions)").setParameter("commentId", (Object)commentId).setParameterList("actions", EnumSet.of(CommentAction.ADDED, CommentAction.REPLIED));
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)query.uniqueResult()));
    }

    public InternalPullRequest findByRepositoryScopedId(int repositoryId, long pullRequestId) {
        Query query = this.session().createQuery("from InternalPullRequest where toRef.repository.id = :repositoryId and scopedId = :pullRequestId").setParameter("repositoryId", (Object)repositoryId).setParameter("pullRequestId", (Object)pullRequestId);
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)query.uniqueResult()));
    }

    public InternalPullRequest findByRefs(@Nonnull InternalPullRequestRef from, @Nonnull InternalPullRequestRef to) {
        Query query = this.session().createQuery("from InternalPullRequest where state = :state and fromRef.repository.id = :fromRepositoryId and fromRef.id = :fromBranchFqn and toRef.repository.id = :toRepositoryId and toRef.id = :toBranchFqn").setString("fromBranchFqn", from.getId()).setInteger("fromRepositoryId", from.getRepository().getId()).setString("toBranchFqn", to.getId()).setInteger("toRepositoryId", to.getRepository().getId()).setParameter("state", (Object)PullRequestState.OPEN);
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)query.uniqueResult()));
    }

    @Nonnull
    public Page<InternalPullRequest> findUnmergedByFromRepository(int repositoryId, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalPullRequest.class).add((Criterion)Restrictions.eq((String)"fromRef.repository.id", (Object)repositoryId)).add((Criterion)Restrictions.ne((String)"state", (Object)PullRequestState.MERGED)).addOrder(Order.asc((String)"id"));
        return this.pageCriteria(criteria, pageRequest);
    }

    @Override
    public InternalPullRequest getById(Long id) {
        return (InternalPullRequest)HibernateUtils.initialize(super.getById(id));
    }

    public int overwriteFromRepository(int repositoryId) {
        Session session = this.session();
        int updated = session.createQuery("update InternalPullRequest set fromRef.repository.id = toRef.repository.id where fromRef.repository.id = :repoId").setInteger("repoId", repositoryId).executeUpdate();
        session.flush();
        return updated;
    }

    @Nonnull
    public Page<InternalPullRequest> search(@Nonnull PullRequestSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalPullRequest> predicate) {
        return HibernateUtils.initializePage(this.pageQuery(new PullRequestSearchQueryHelper(searchCriteria).build(this.session()), pageRequest, predicate));
    }

    @Override
    public InternalPullRequest update(InternalPullRequest entity) {
        return (InternalPullRequest)HibernateUtils.initialize((Object)super.update(entity));
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.desc((String)"updatedDate"));
    }

    private Map<PullRequestState, Long> countByState(List<Object[]> results) {
        HashMap countByState = Maps.newHashMapWithExpectedSize((int)results.size());
        for (Object[] column : results) {
            countByState.put((PullRequestState)column[0], (Long)column[1]);
        }
        return ImmutableMap.copyOf((Map)countByState);
    }

    private void deleteTasksByScopeRepository(int repositoryId) {
        final PullRequestSearchCriteria searchCriteria = new PullRequestSearchCriteria.Builder().toRepositoryId(Integer.valueOf(repositoryId)).build();
        PagedIterable pullRequests = new PagedIterable((PageProvider)new PageProvider<InternalPullRequest>(){

            public Page<InternalPullRequest> get(PageRequest request) {
                return HibernatePullRequestDao.this.search(searchCriteria, request, p -> true);
            }
        }, 500);
        this.taskDao.deleteForContexts((Iterable)pullRequests);
    }

    private void deleteComments(List<Long> commentIds) {
        if (commentIds.isEmpty()) {
            return;
        }
        for (List ids : Lists.partition(commentIds, (int)100)) {
            this.session().createQuery("delete from InternalComment where id in (:commentIds)").setParameterList("commentIds", (Collection)ids).executeUpdate();
        }
    }
}

