/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.fugue.Option;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import liquibase.util.ISODateFormat;

public enum ColumnSerialisationType {
    BOOLEAN("boolean"),
    DATE("date"){

        @Override
        @Nonnull
        public String toColumnString(@Nonnull Object value) {
            return new ISODateFormat().format((Date)value);
        }
    }
    ,
    NUMERIC("numeric"),
    CHARACTER("character");

    private static final Map<String, ColumnSerialisationType> STRING_TO_COLUMN_TYPE;
    private final String stringValue;

    public static Option<ColumnSerialisationType> fromString(String s) {
        return Option.option((Object)((Object)STRING_TO_COLUMN_TYPE.get(s)));
    }

    public static ColumnSerialisationType ofValue(Object value) {
        if (value instanceof Number) {
            return NUMERIC;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof Date) {
            return DATE;
        }
        return CHARACTER;
    }

    private ColumnSerialisationType(String stringValue) {
        this.stringValue = stringValue;
    }

    public String toString() {
        return this.stringValue;
    }

    @Nonnull
    public String toColumnString(@Nonnull Object value) {
        return value.toString();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnSerialisationType columnSerialisationType : ColumnSerialisationType.values()) {
            builder.put((Object)columnSerialisationType.stringValue, (Object)columnSerialisationType);
        }
        STRING_TO_COLUMN_TYPE = builder.build();
    }
}

