/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.dao.IncorrectUpdateSemanticsDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@DependsOn(value={"bootstrapLiquibase"})
@Repository(value="applicationPropertyDao")
public class JdbcApplicationPropertyDao
implements ApplicationPropertyDao {
    private static final ApplicationPropertyMapper MAPPER = new ApplicationPropertyMapper();
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final Validator validator;

    @Autowired
    public JdbcApplicationPropertyDao(NamedParameterJdbcTemplate jdbcTemplate, Validator validator) {
        this.validator = validator;
        this.jdbcTemplate = jdbcTemplate;
    }

    public ApplicationProperty create(@Nonnull ApplicationProperty property) {
        ValidationUtils.validate((Validator)this.validator, (Object)property, (Class[])new Class[0]);
        this.jdbcTemplate.update("INSERT INTO app_property (prop_key, prop_value) VALUES (:prop_key, :prop_value)", this.toParamSource(property));
        return property;
    }

    public void deleteById(@Nonnull ApplicationProperty.Key key) {
        this.jdbcTemplate.update("DELETE FROM app_property WHERE prop_key = :prop_key", this.toParamSource(key));
    }

    public ApplicationProperty getById(@Nonnull ApplicationProperty.Key key) {
        return (ApplicationProperty)DataAccessUtils.uniqueResult((Collection)this.jdbcTemplate.query("SELECT prop_key, prop_value FROM app_property WHERE prop_key = :prop_key", this.toParamSource(key), (RowMapper)MAPPER));
    }

    public ApplicationProperty update(@Nonnull ApplicationProperty property) {
        ValidationUtils.validate((Validator)this.validator, (Object)property, (Class[])new Class[0]);
        int updated = this.jdbcTemplate.update("UPDATE app_property SET prop_value = :prop_value WHERE prop_key = :prop_key", this.toParamSource(property));
        if (updated != 1) {
            throw new IncorrectUpdateSemanticsDataAccessException("Incorrect number of rows updated: expected 1, actual " + updated);
        }
        return property;
    }

    public boolean isSetup() {
        ApplicationProperty value = this.getById(ApplicationProperty.Key.SETUP_COMPLETED);
        return value != null && Boolean.parseBoolean(value.getValue());
    }

    private SqlParameterSource toParamSource(ApplicationProperty property) {
        return new MapSqlParameterSource().addValue("prop_key", (Object)property.getKey().getId()).addValue("prop_value", (Object)property.getValue());
    }

    private SqlParameterSource toParamSource(ApplicationProperty.Key key) {
        return new MapSqlParameterSource("prop_key", (Object)key.getId());
    }

    private static class ApplicationPropertyMapper
    implements RowMapper<ApplicationProperty> {
        private ApplicationPropertyMapper() {
        }

        public ApplicationProperty mapRow(ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString(1);
            String value = rs.getString(2);
            return new ApplicationProperty(ApplicationProperty.Key.fromId((String)id), value);
        }
    }
}

