/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.idx.InternalIndexerState;
import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class ChangesetIndexerDedupeChange
extends AbstractCustomChange
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(ChangesetIndexerDedupeChange.class);

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
        Map<InternalIndexerState.PK, Long> dupeLastRunForRepoIndexer = this.findDuplicateEntries(template);
        log.debug("{} duplicate cs_indexer_state rows found", (Object)dupeLastRunForRepoIndexer.size());
        if (!dupeLastRunForRepoIndexer.isEmpty()) {
            this.deleteDupeEntries(template, dupeLastRunForRepoIndexer);
            this.recreateEntries(template, dupeLastRunForRepoIndexer);
            log.debug("Duplicate cs_indexer_state rows deleted");
        }
    }

    private void recreateEntries(JdbcTemplate template, Map<InternalIndexerState.PK, Long> dupeLastRunForRepoIndexer) throws CustomChangeException {
        try {
            List entryBatches = Lists.partition((List)Lists.newArrayList(dupeLastRunForRepoIndexer.entrySet()), (int)25);
            for (final List entries : entryBatches) {
                template.batchUpdate("insert into cs_indexer_state (repository_id, indexer_id, last_run) values (?, ?, ?)", new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        Map.Entry entry = (Map.Entry)entries.get(i);
                        ps.setInt(1, ((InternalIndexerState.PK)entry.getKey()).getRepositoryId());
                        ps.setString(2, ((InternalIndexerState.PK)entry.getKey()).getIndexerId());
                        ps.setLong(3, (Long)entry.getValue());
                    }

                    public int getBatchSize() {
                        return entries.size();
                    }
                });
            }
        }
        catch (DataAccessException e) {
            log.error("Failed to create cs_indexer_state rows", (Throwable)e);
            throw new CustomChangeException("Failed to create cs_indexer_state rows", (Throwable)e);
        }
    }

    private void deleteDupeEntries(JdbcTemplate template, Map<InternalIndexerState.PK, Long> dupeLastRunForRepoIndexer) throws CustomChangeException {
        try {
            List batches = Lists.partition((List)Lists.newArrayList(dupeLastRunForRepoIndexer.keySet()), (int)25);
            for (final List indexStateKeysToRemove : batches) {
                template.batchUpdate("delete from cs_indexer_state where repository_id = ? and indexer_id = ?", new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        ps.setInt(1, ((InternalIndexerState.PK)indexStateKeysToRemove.get(i)).getRepositoryId());
                        ps.setString(2, ((InternalIndexerState.PK)indexStateKeysToRemove.get(i)).getIndexerId());
                    }

                    public int getBatchSize() {
                        return indexStateKeysToRemove.size();
                    }
                });
            }
        }
        catch (DataAccessException e) {
            log.error("Failed to delete some duplicate cs_indexer_state rows", (Throwable)e);
            throw new CustomChangeException("Failed to delete some duplicate cs_indexer_state rows", (Throwable)e);
        }
    }

    private Map<InternalIndexerState.PK, Long> findDuplicateEntries(JdbcTemplate template) throws CustomChangeException {
        final HashMap dupeLastRunForRepoIndexer = Maps.newHashMap();
        try {
            template.query("select repository_id, indexer_id, max(last_run) as last_run from cs_indexer_state group by repository_id, indexer_id having count(1) > 1", new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    dupeLastRunForRepoIndexer.put(new InternalIndexerState.PK(rs.getString("indexer_id"), rs.getInt("repository_id")), rs.getLong("last_run"));
                }
            });
            return dupeLastRunForRepoIndexer;
        }
        catch (DataAccessException e) {
            log.error("Failed to query cs_indexer_state", (Throwable)e);
            throw new CustomChangeException("Failed to query cs_indexer_state", (Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return "Duplicate entries in cs_indexer_state removed.";
    }
}

