/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DiffCommentAnchorSearchCriteria {
    private final String fromHash;
    private final String path;
    private final String toHash;

    private DiffCommentAnchorSearchCriteria(Builder builder) {
        this.fromHash = builder.fromHash;
        this.path = builder.path;
        this.toHash = builder.toHash;
    }

    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getToHash() {
        return this.toHash;
    }

    public boolean hasFromHash() {
        return StringUtils.isNotBlank((CharSequence)this.fromHash);
    }

    public boolean hasPath() {
        return StringUtils.isNotBlank((CharSequence)this.path);
    }

    public boolean hasToHash() {
        return StringUtils.isNotBlank((CharSequence)this.toHash);
    }

    public static class Builder {
        private String fromHash;
        private String path;
        private String toHash;

        @Nonnull
        public DiffCommentAnchorSearchCriteria build() {
            return new DiffCommentAnchorSearchCriteria(this);
        }

        @Nonnull
        public Builder fromHash(@Nullable String value) {
            this.fromHash = value;
            return this.self();
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            this.path = value;
            return this.self();
        }

        @Nonnull
        public Builder toHash(@Nullable String value) {
            this.toHash = value;
            return this.self();
        }

        private Builder self() {
            return this;
        }
    }
}

