/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationLocation;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotationService;
import com.atlassian.bitbucket.codeinsights.annotation.SearchAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.report.GetInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.codeinsights.report.InsightReportService;
import com.atlassian.bitbucket.codeinsights.report.SearchInsightReportRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.rest.AbstractInsightResource;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReport;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}")
public class PullRequestInsightResource
extends AbstractInsightResource {
    private final InsightAnnotationService insightAnnotationService;
    private final InsightReportService insightReportService;

    @Inject
    public PullRequestInsightResource(I18nService i18nService, InsightAnnotationService insightAnnotationService, InsightReportService insightReportService) {
        super(i18nService);
        this.insightAnnotationService = insightAnnotationService;
        this.insightReportService = insightReportService;
    }

    @GET
    @Path(value="annotations")
    public Response getAnnotations(final @BeanParam PullRequestResolver pullRequestResolver, final @QueryParam(value="key") List<String> keys, final @QueryParam(value="externalId") List<String> externalIds, final @QueryParam(value="path") List<String> paths, final @QueryParam(value="severity") List<AnnotationSeverity> severities, final @QueryParam(value="type") List<AnnotationType> type, final @QueryParam(value="annotationLocation") @DefaultValue(value="LINES") AnnotationLocation annotationLocation) {
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                SearchAnnotationRequest request = new SearchAnnotationRequest.Builder(pullRequestResolver.getPullRequest()).reportKeys(keys).externalIds(externalIds).paths(paths).severities(severities).types(type).annotationLocation(annotationLocation).build();
                PullRequestInsightResource.this.insightAnnotationService.stream(request, new RestPullRequestAnnotationCallback(writer, pullRequestResolver.getPullRequest()));
            }
        }).build();
    }

    @GET
    @Path(value="reports/{key}")
    public Response getReport(@BeanParam PullRequestResolver pullRequestResolver, @PathParam(value="key") String key) {
        return this.insightReportService.get(new GetInsightReportRequest.Builder(pullRequestResolver.getPullRequest(), key).build()).map(c -> ResponseFactory.ok((Object)((Object)new RestInsightReport((InsightReport)c))).build()).orElseGet(() -> ResponseFactory.notFound().entity((Object)this.noSuchReport(key)).build());
    }

    @GET
    @Path(value="reports/{key}/annotations")
    public Response getReportAnnotations(final @BeanParam PullRequestResolver pullRequestResolver, final @PathParam(value="key") String key, final @QueryParam(value="externalId") List<String> externalIds, final @QueryParam(value="path") List<String> paths, final @QueryParam(value="severity") List<AnnotationSeverity> severities, final @QueryParam(value="types") List<AnnotationType> types) {
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                SearchAnnotationRequest request = new SearchAnnotationRequest.Builder(pullRequestResolver.getPullRequest()).reportKey(key).externalIds(externalIds).paths(paths).severities(severities).types(types).build();
                PullRequestInsightResource.this.insightAnnotationService.stream(request, new RestPullRequestAnnotationCallback(writer, pullRequestResolver.getPullRequest()));
            }
        }).build();
    }

    @GET
    @Path(value="reports")
    public Response getReports(@BeanParam PullRequestResolver pullRequestResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        Page<InsightReport> reports = this.insightReportService.search(new SearchInsightReportRequest.Builder(pullRequestResolver.getPullRequest()).build(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(reports, RestInsightReport::new)).build();
    }

    static class RestPullRequestAnnotationCallback
    extends AbstractInsightResource.RestAnnotationCallback {
        private final PullRequest pullRequest;

        RestPullRequestAnnotationCallback(StatefulJsonWriter writer, PullRequest pullRequest) {
            super(writer);
            this.pullRequest = pullRequest;
        }

        @Override
        protected void beforeEndObject(boolean truncated) throws IOException {
            super.beforeEndObject(truncated);
            this.writer.name("truncated").value(truncated);
            this.writer.name("pullRequest").value((Object)new RestPullRequest(this.pullRequest));
        }
    }
}

