/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.report;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class InsightReportDataValidator {
    private static final List<String> SUPPORTED_URL_SCHEMES = ImmutableList.of((Object)"http", (Object)"https");
    private final I18nService i18nService;

    public InsightReportDataValidator(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public void validate(JsonNode node) {
        JsonNode type = node.get("type");
        JsonNode value = node.get("value");
        if (node.get("title").isTextual() && this.isMatchingType(type, value)) {
            return;
        }
        if (type.isNull() || type.isMissingNode()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.data.invalid.primitivevalue", new Object[0]));
        }
        throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.data.invalid", new Object[]{value, type}));
    }

    private boolean isMatchingType(JsonNode type, JsonNode value) {
        if (type.isNull() || type.isMissingNode()) {
            return value.isValueNode() && !value.isNull();
        }
        switch (type.textValue()) {
            case "BOOLEAN": {
                return value.isBoolean();
            }
            case "DATE": {
                return value.isNumber();
            }
            case "DURATION": {
                return value.isNumber() && value.asDouble() >= 0.0;
            }
            case "NUMBER": 
            case "PERCENTAGE": {
                return value.isNumber();
            }
            case "TEXT": {
                return value.isTextual();
            }
            case "LINK": {
                return this.isValidLink(value);
            }
        }
        throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.data.format", new Object[]{type}));
    }

    private boolean isValidLink(URI url) {
        return SUPPORTED_URL_SCHEMES.contains(url.getScheme());
    }

    private boolean isValidLink(JsonNode value) {
        if (!value.isObject() || value.size() != 2) {
            return false;
        }
        JsonNode href = value.get("href");
        JsonNode linktext = value.get("linktext");
        if (href == null || linktext == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.data.link.format", new Object[0]));
        }
        if (!href.isTextual() || !linktext.isTextual()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.data.link.textual", new Object[0]));
        }
        String uri = href.textValue();
        try {
            return this.isValidLink(UrlUtils.uncheckedCreateURI((String)uri));
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.data.link.uri", new Object[]{uri}));
        }
    }
}

