/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.report;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.codeinsights.report.AbstractInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.DeleteInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.GetInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.codeinsights.report.SearchInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.SetInsightReportRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.analytics.AnalyticsReportCreatedEvent;
import com.atlassian.bitbucket.internal.codeinsights.analytics.AnalyticsReportDeletedEvent;
import com.atlassian.bitbucket.internal.codeinsights.analytics.AnalyticsReportUpdatedEvent;
import com.atlassian.bitbucket.internal.codeinsights.dao.InsightReportDao;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightReport;
import com.atlassian.bitbucket.internal.codeinsights.dao.SetInsightReportParameters;
import com.atlassian.bitbucket.internal.codeinsights.dao.SqlUtils;
import com.atlassian.bitbucket.internal.codeinsights.report.InsightReportDataValidator;
import com.atlassian.bitbucket.internal.codeinsights.report.InternalInsightReportService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.auth.OAuthRequestVerifierFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="insightReportService")
public class DefaultInsightReportService
implements InternalInsightReportService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int MAX_REPORTS_PER_PAGE = 100;
    private static final Logger log = LoggerFactory.getLogger(DefaultInsightReportService.class);
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final InsightReportDataValidator insightDataValidator;
    private final EventPublisher eventPublisher;
    private final InsightReportDao insightReportDao;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final OAuthRequestVerifierFactory requestVerifierFactory;
    private final ScmService scmService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public DefaultInsightReportService(AuthenticationContext authenticationContext, EventPublisher eventPublisher, I18nService i18nService, InsightReportDao insightReportDao, InsightReportDataValidator insightDataValidator, PermissionService permissionService, PermissionValidationService permissionValidationService, OAuthRequestVerifierFactory requestVerifierFactory, ScmService scmService, TransactionTemplate transactionTemplate) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.insightReportDao = insightReportDao;
        this.insightDataValidator = insightDataValidator;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.requestVerifierFactory = requestVerifierFactory;
        this.transactionTemplate = transactionTemplate;
        this.i18nService = i18nService;
        this.scmService = scmService;
    }

    @Override
    public void delete(@Nonnull DeleteInsightReportRequest request) {
        this.validateUserIsEitherBasicOrOAuth();
        Repository repository = request.getRepository();
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
        try {
            this.transactionTemplate.execute(() -> {
                InternalInsightReport report = this.insightReportDao.get(repository.getId(), request.getCommitId(), request.getKey());
                if (report != null) {
                    this.validateCanDelete(report, repository.getId());
                    this.insightReportDao.delete(report);
                    this.eventPublisher.publish((Object)new AnalyticsReportDeletedEvent(repository, report));
                }
                return null;
            });
        }
        catch (RuntimeException e) {
            if (SqlUtils.isForeignKeyViolation(e)) {
                log.warn("{}/{}: Could not delete report with key '{}'. This is likely caused by a race condition where two services are deleting or posting the same insight report and annotations.", new Object[]{request.getRepository().getProject().getKey(), request.getRepository().getSlug(), request.getKey()});
                throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.reports.concurrent.add.annotation", new Object[]{request.getKey()}), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public int deleteExpiredReports(@Nonnull Date date) {
        Objects.requireNonNull(date, "date");
        MutableObject currentPage = new MutableObject();
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)1000);
        int deleted = 0;
        do {
            deleted += ((Integer)this.transactionTemplate.execute(() -> {
                Page<InternalInsightReport> expired = this.insightReportDao.findCreatedBefore(date, pageRequest);
                currentPage.setValue(expired);
                return this.insightReportDao.deleteById((Long[])expired.stream().map(InternalInsightReport::getID).toArray(Long[]::new));
            })).intValue();
        } while (!((Page)currentPage.getValue()).getIsLastPage());
        return deleted;
    }

    @Override
    @Nonnull
    public Optional<InsightReport> get(@Nonnull GetInsightReportRequest request) {
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForRepository(this.getTargetRepository(request), Permission.REPO_READ);
        String commitId = request.getCommitId();
        Repository repository = request.getRepository();
        String key = request.getKey();
        try (Timer ignored = TimerUtils.start((String)String.format("CodeInsights: finding report for commit %s in %s with report key '%s'", commitId, repository, key));){
            Optional<InsightReport> optional = Optional.ofNullable((InsightReport)this.transactionTemplate.execute(() -> {
                InternalInsightReport report = this.insightReportDao.get(repository.getId(), commitId, key);
                return report == null ? null : this.initialize(report, repository);
            }));
            return optional;
        }
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        boolean complete;
        int repositoryId = event.getRepository().getId();
        while (!(complete = ((Boolean)this.transactionTemplate.execute(() -> {
            Page<InternalInsightReport> expired = this.insightReportDao.findForRepository(repositoryId, PageUtils.newRequest((int)0, (int)1000));
            this.insightReportDao.deleteById((Long[])expired.stream().map(InternalInsightReport::getID).toArray(Long[]::new));
            return expired.getIsLastPage();
        })).booleanValue())) {
        }
    }

    @Override
    @Nonnull
    public Page<InsightReport> search(@Nonnull SearchInsightReportRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.permissionValidationService.validateForRepository(this.getTargetRepository(request), Permission.REPO_READ);
        Repository repository = request.getRepository();
        try (Timer ignored = TimerUtils.start((String)String.format("CodeInsights: finding reports for commit %s in %d", request.getCommitId(), repository.getId()));){
            Page page = ((Page)this.transactionTemplate.execute(() -> this.insightReportDao.find(repository.getId(), request.getCommitId(), request.getReportKeys(), pageRequest.buildRestrictedPageRequest(100)))).transform(internalReport -> this.initialize((InternalInsightReport)internalReport, repository));
            return page;
        }
    }

    @Override
    @Nonnull
    public InsightReport set(@Nonnull SetInsightReportRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateUserIsEitherBasicOrOAuth();
        Repository repository = request.getRepository();
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
        if (request.getData().size() > 6) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.data.size", new Object[0]));
        }
        String commitId = this.resolveCommit(request.getCommitId(), repository).getId();
        try (Timer ignored = TimerUtils.start((String)String.format("Creating report for commit '%s' in repository %s", commitId, repository));){
            String data = this.maybeSerialize(request.getData());
            String key = request.getKey();
            String link = this.toASCIIString(request.getLink());
            String logoUrl = this.toASCIIString(request.getLogoUrl());
            Integer resultId = this.asResultId(request.getResult());
            String title = request.getTitle();
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            InsightReport insightReport = (InsightReport)this.transactionTemplate.execute(() -> {
                InternalInsightReport created;
                SetInsightReportParameters parameters = new SetInsightReportParameters.Builder(commitId, key, repository, title).coverageProviderKey(request.getCoverageProviderKey()).data(data).details(request.getDetails()).link(link).logoUrl(logoUrl).resultId(resultId).reporter(request.getReporter()).authorId(currentUser != null ? Integer.valueOf(currentUser.getId()) : null).build();
                InternalInsightReport existing = this.insightReportDao.get(repository.getId(), commitId, key);
                if (existing == null) {
                    created = this.insightReportDao.create(parameters);
                } else {
                    this.validateCanUpdate(existing);
                    created = this.insightReportDao.update(existing, parameters);
                }
                this.initialize(created, request.getData(), repository);
                if (existing == null) {
                    this.eventPublisher.publish((Object)new AnalyticsReportCreatedEvent(repository, created));
                } else {
                    this.eventPublisher.publish((Object)new AnalyticsReportUpdatedEvent(repository, created));
                }
                return created;
            });
            return insightReport;
        }
    }

    private Integer asResultId(InsightResult result) {
        return result == null ? null : Integer.valueOf(result.getId());
    }

    private Optional<Integer> getCurrentUserId() {
        return Optional.ofNullable(this.authenticationContext.getCurrentUser()).map(ApplicationUser::getId);
    }

    private Repository getTargetRepository(AbstractInsightReportRequest request) {
        return request.getPullRequest().map(pullRequest -> pullRequest.getToRef().getRepository()).orElseGet(request::getRepository);
    }

    private void initialize(InternalInsightReport report, List<InsightReportData> data, Repository repository) {
        report.initialize(repository, data);
    }

    private InsightReport initialize(InternalInsightReport report, Repository repository) {
        report.initialize(repository, this.maybeDeserialize(report.getInternalData()));
        return report;
    }

    private List<InsightReportData> maybeDeserialize(String data) {
        try (Timer ignored = TimerUtils.start((String)"CodeInsights: deserializing data");){
            if (data == null) {
                List<InsightReportData> list = Collections.emptyList();
                return list;
            }
            List list = (List)OBJECT_MAPPER.readValue(data, (TypeReference)new TypeReference<List<InsightReportData>>(){});
            return list;
        }
    }

    private String maybeSerialize(List<InsightReportData> data) {
        try (Timer ignored = TimerUtils.start((String)"CodeInsights: serializing data");){
            if (data.isEmpty()) {
                String string = null;
                return string;
            }
            ArrayNode jsonNode = (ArrayNode)OBJECT_MAPPER.valueToTree(data);
            jsonNode.forEach(this.insightDataValidator::validate);
            String string = jsonNode.toString();
            return string;
        }
    }

    private Commit resolveCommit(String commitId, Repository repository) {
        Commit commit = (Commit)this.scmService.getCommandFactory(repository).commit(((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().commitId(commitId)).maxMessageLength(0).build()).call();
        if (commit == null) {
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.reports.repository.commitnotfound", new Object[]{repository, commitId}), commitId);
        }
        return commit;
    }

    private String toASCIIString(URI url) {
        return url == null ? null : url.toASCIIString();
    }

    private void validateCanDelete(InternalInsightReport report, int repositoryId) {
        Optional<Integer> existingReportId = report.getAuthorId();
        if (existingReportId.equals(this.getCurrentUserId()) || this.permissionService.hasRepositoryPermission(repositoryId, Permission.REPO_ADMIN)) {
            return;
        }
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.delete.author", new Object[0]));
    }

    private void validateCanUpdate(InternalInsightReport report) {
        if (report.getAuthorId().equals(this.getCurrentUserId())) {
            return;
        }
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.edit.author", new Object[0]));
    }

    private void validateUserIsEitherBasicOrOAuth() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null ^ this.requestVerifierFactory.getInstance(null).isVerified()) {
            return;
        }
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.codeinsights.error.anonymous", new Object[0]));
    }
}

