/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.mergecheck;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotationService;
import com.atlassian.bitbucket.codeinsights.annotation.SearchAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.codeinsights.report.InsightReportService;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.codeinsights.report.SearchInsightReportRequest;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InsightReportCondition;
import com.atlassian.bitbucket.internal.codeinsights.mergecheck.InternalInsightMergeCheckService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.PageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class InsightReportConditionMergeCheck
implements RepositoryMergeCheck {
    private static final int PAGE_SIZE = 20;
    private final I18nService i18nService;
    private final InsightAnnotationService insightAnnotationService;
    private final InternalInsightMergeCheckService insightMergeCheckService;
    private final InsightReportService insightReportService;

    public InsightReportConditionMergeCheck(@Nonnull I18nService i18nService, @Nonnull InsightAnnotationService insightAnnotationService, @Nonnull InternalInsightMergeCheckService insightMergeCheckService, @Nonnull InsightReportService insightReportService) {
        this.i18nService = i18nService;
        this.insightAnnotationService = insightAnnotationService;
        this.insightMergeCheckService = insightMergeCheckService;
        this.insightReportService = insightReportService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        PullRequest pullRequest = request.getPullRequest();
        Repository repository = pullRequest.getToRef().getRepository();
        Map conditions = PageUtils.toStream(pageRequest -> this.insightMergeCheckService.getInsightReportConditions((Scope)Scopes.repository((Repository)repository), pageRequest), (int)20).collect(Collectors.groupingBy(condition -> condition.getReportKey().toLowerCase(Locale.US), Collectors.toSet()));
        if (conditions.isEmpty()) {
            return new RepositoryHookResult.Builder().build();
        }
        SearchInsightReportRequest searchRequest = new SearchInsightReportRequest.Builder(pullRequest).reportKeys(conditions.keySet()).build();
        Map<String, InsightReport> reports = PageUtils.toStream(pageRequest -> this.insightReportService.search(searchRequest, pageRequest), (int)20).collect(Collectors.toMap(InsightReport::getKey, report -> report));
        RepositoryHookResult.Builder result = new RepositoryHookResult.Builder();
        conditions.forEach((reportKey, conditionsForKey) -> {
            InsightReport report = (InsightReport)reports.get(reportKey);
            if (report == null) {
                result.veto(this.i18nService.getMessage("bitbucket.codeinsights.mergecheck.report.missing.summary", new Object[0]), this.i18nService.getMessage("bitbucket.codeinsights.mergecheck.report.missing.detail", new Object[]{reportKey}));
            } else {
                Set prohibitedSeverities;
                boolean isMustPass = conditionsForKey.stream().anyMatch(InsightReportCondition::isMustPass);
                if (isMustPass && report.getResult().map(r -> r != InsightResult.PASS).orElse(true).booleanValue()) {
                    result.veto(this.i18nService.getMessage("bitbucket.codeinsights.mergecheck.report.failed.summary", new Object[0]), this.i18nService.getMessage("bitbucket.codeinsights.mergecheck.report.failed.detail", new Object[]{report.getTitle()}));
                }
                if (!(prohibitedSeverities = conditionsForKey.stream().flatMap(condition -> MoreStreams.streamOptional(condition.getMinimumProhibitedSeverity())).min(Comparator.comparingInt(AnnotationSeverity::getId)).map(minimumProhibitedSeverity -> Arrays.stream(AnnotationSeverity.values()).filter(severity -> severity.getId() >= minimumProhibitedSeverity.getId()).collect(Collectors.toSet())).orElseGet(Collections::emptySet)).isEmpty()) {
                    SearchAnnotationRequest annotationRequest = new SearchAnnotationRequest.Builder(pullRequest).reportKey(report.getKey()).severities(prohibitedSeverities).build();
                    this.insightAnnotationService.stream(annotationRequest, annotation -> {
                        result.veto(this.i18nService.getMessage("bitbucket.codeinsights.mergecheck.annotation.failed.summary", new Object[0]), prohibitedSeverities.size() == 3 ? this.i18nService.getMessage("bitbucket.codeinsights.mergecheck.annotation.failed.low", new Object[]{report.getTitle()}) : this.i18nService.getMessage("bitbucket.codeinsights.mergecheck.annotation.failed.detail", new Object[]{prohibitedSeverities.size(), report.getTitle()}));
                        return false;
                    });
                }
            }
        });
        return result.build();
    }
}

