/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotation;
import com.atlassian.bitbucket.rest.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RestInsightAnnotation
extends RestMapEntity {
    public static final String REPORT_KEY = "reportKey";
    public static final String EXTERNAL_ID = "externalId";
    public static final String LINE = "line";
    public static final String LINK = "link";
    public static final String MESSAGE = "message";
    public static final String PATH = "path";
    public static final String SEVERITY = "severity";

    public RestInsightAnnotation() {
    }

    public RestInsightAnnotation(String reportKey, Optional<String> externalId, Integer line, Optional<URI> deeplink, String message, String path, AnnotationSeverity severity, Optional<AnnotationType> type) {
        this.put(REPORT_KEY, reportKey);
        externalId.ifPresent(id -> this.put(EXTERNAL_ID, id));
        this.putIfNotNull(LINE, line);
        deeplink.ifPresent(link -> this.put(LINK, link.toASCIIString()));
        this.put(MESSAGE, message);
        this.put(PATH, StringUtils.stripToEmpty((String)path));
        this.put(SEVERITY, severity.toString());
        type.ifPresent(t -> this.put("type", t.toString()));
    }

    public RestInsightAnnotation(InsightAnnotation annotation) {
        this(annotation.getReportKey(), annotation.getExternalId(), annotation.getLine(), annotation.getLink(), annotation.getMessage(), annotation.getFilePath().orElse(""), annotation.getSeverity(), annotation.getType());
    }

    @Schema(example="external.id")
    public String getExternalId() {
        return this.getStringProperty(EXTERNAL_ID);
    }

    @Schema(example="5")
    public int getLine() {
        return this.getIntProperty(LINE);
    }

    @Schema(example="http://example.com/my/file/analysis?line=5")
    public String getLink() {
        return this.getStringProperty(LINK);
    }

    @Schema(example="This is an annotation message")
    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @Schema(example="src/some/structure/file.ext")
    public String getPath() {
        return this.getStringProperty(PATH);
    }

    @Schema(example="report.key")
    public String getReportKey() {
        return this.getStringProperty(REPORT_KEY);
    }

    @Schema(example="HIGH")
    public String getSeverity() {
        return this.getStringProperty(SEVERITY);
    }

    @Schema(example="BUG")
    public String getType() {
        return this.getStringProperty("type");
    }
}

