define('bitbucket-plugin-code-insights/internal/page/settings/components/merge-check-settings-row', ['exports', '@atlassian/aui', 'lodash', 'react'], function (exports, _aui, _lodash, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.TableRow = exports.SeverityCodes = undefined;
    exports.AddSettingRow = AddSettingRow;

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    var _SeverityStrings;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var SeverityCodes = exports.SeverityCodes = {
        LOW: 'LOW',
        MEDIUM: 'MEDIUM',
        HIGH: 'HIGH',
        ALLOW_ALL: 'ALLOW_ALL'
    };

    var SeverityStrings = (_SeverityStrings = {}, _defineProperty(_SeverityStrings, SeverityCodes.LOW, _aui.I18n.getText('bitbucket.codeinsights.mergecheck.minseverity.low')), _defineProperty(_SeverityStrings, SeverityCodes.MEDIUM, _aui.I18n.getText('bitbucket.codeinsights.mergecheck.minseverity.medium')), _defineProperty(_SeverityStrings, SeverityCodes.HIGH, _aui.I18n.getText('bitbucket.codeinsights.mergecheck.minseverity.high')), _defineProperty(_SeverityStrings, SeverityCodes.ALLOW_ALL, _aui.I18n.getText('bitbucket.codeinsights.mergecheck.minseverity.all')), _SeverityStrings);

    var SettingSource = function SettingSource(_ref) {
        var projectSettingsUrl = _ref.projectSettingsUrl,
            text = _ref.text;
        return _react2.default.createElement(
            'span',
            { className: 'setting-source' },
            projectSettingsUrl ? _react2.default.createElement(
                'a',
                { href: projectSettingsUrl },
                text
            ) : text
        );
    };

    var TableRow = exports.TableRow = function TableRow(_ref2) {
        var reportKey = _ref2.reportKey,
            mustPass = _ref2.mustPass,
            minProhibitedSeverity = _ref2.minProhibitedSeverity,
            removeSetting = _ref2.removeSetting,
            isInherited = _ref2.isInherited,
            inheritUrl = _ref2.inheritUrl;
        return _react2.default.createElement(
            'tr',
            { 'data-is-inherited': isInherited },
            _react2.default.createElement(
                'td',
                { headers: 'report-key' },
                reportKey,
                isInherited ? _react2.default.createElement(SettingSource, {
                    projectSettingsUrl: inheritUrl,
                    text: _aui.I18n.getText('bitbucket.web.project.tabs.settings')
                }) : ''
            ),
            _react2.default.createElement(
                'td',
                { headers: 'requires-non-failing' },
                mustPass ? _react2.default.createElement(
                    'span',
                    { className: 'aui-lozenge aui-lozenge-success' },
                    _aui.I18n.getText('bitbucket.codeinsights.mergecheck.mustpass.lozenge')
                ) : ''
            ),
            _react2.default.createElement(
                'td',
                { headers: 'min-disallowed-sevs' },
                SeverityStrings[minProhibitedSeverity]
            ),
            _react2.default.createElement(
                'td',
                { className: 'actions', headers: 'actions' },
                _react2.default.createElement(
                    'button',
                    {
                        type: 'button',
                        className: 'aui-button aui-button-subtle',
                        disabled: isInherited,
                        onClick: function onClick() {
                            return removeSetting(reportKey);
                        }
                    },
                    _react2.default.createElement(
                        'span',
                        { className: 'aui-icon aui-icon-small aui-iconfont-cross-circle' },
                        _aui.I18n.getText('bitbucket.codeinsights.mergecheck.delete.help', reportKey)
                    )
                )
            )
        );
    };

    function AddSettingRow(props) {
        var _useState = (0, _react.useState)(''),
            _useState2 = _slicedToArray(_useState, 2),
            reportKey = _useState2[0],
            setReportKey = _useState2[1];

        var _useState3 = (0, _react.useState)(true),
            _useState4 = _slicedToArray(_useState3, 2),
            mustPass = _useState4[0],
            setMustPass = _useState4[1];

        var _useState5 = (0, _react.useState)(SeverityCodes.LOW),
            _useState6 = _slicedToArray(_useState5, 2),
            minProhibitedSeverity = _useState6[0],
            setMinProhibitedSeverity = _useState6[1];

        var _useState7 = (0, _react.useState)(null),
            _useState8 = _slicedToArray(_useState7, 2),
            error = _useState8[0],
            setError = _useState8[1];

        var onReportKeyChange = (0, _react.useCallback)(function (e) {
            setReportKey(e.target.value);
            setError(null);
        }, []);
        var onRequiresNonFailingChange = (0, _react.useCallback)(function (e) {
            return setMustPass(e.target.value === 'true');
        }, []);
        var onMinSeverityChange = (0, _react.useCallback)(function (e) {
            return setMinProhibitedSeverity(e.target.value);
        }, []);

        var addSetting = function addSetting() {
            var trimmedReportKey = reportKey.trim();

            // Check for blank report key
            if (trimmedReportKey === '') {
                setError(_aui.I18n.getText('bitbucket.codeinsights.mergecheck.error.reportkey.blank'));

                return;
            }

            // Check for disallowed characters
            if ((0, _lodash.includes)(trimmedReportKey, '/')) {
                setError(_aui.I18n.getText('bitbucket.codeinsights.mergecheck.error.reportkey.slash'));

                return;
            }

            // Check for existing use of report key
            if (props.settings[trimmedReportKey]) {
                setError(_aui.I18n.getText('bitbucket.codeinsights.mergecheck.error.reportkey.exists'));

                return;
            }

            // Validation passed, add the row
            var data = {
                reportKey: trimmedReportKey,
                mustPass: mustPass
            };

            if (minProhibitedSeverity !== SeverityCodes.ALLOW_ALL) {
                data['minProhibitedSeverity'] = minProhibitedSeverity;
            }

            props.onAdd(data);

            // Reset the row so that its ready to add another check
            setReportKey('');
            setMustPass(true);
            setMinProhibitedSeverity(SeverityCodes.LOW);
            setError(null);
        };

        var handleEnterKey = function handleEnterKey(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                addSetting();
            }
        };

        return _react2.default.createElement(
            'tr',
            { className: 'add-form', onKeyDown: handleEnterKey },
            _react2.default.createElement(
                'td',
                { headers: 'report-key' },
                _react2.default.createElement('input', {
                    type: 'text',
                    id: 'input-report-key',
                    name: 'input-report-key',
                    className: 'text long-field',
                    value: reportKey,
                    onChange: onReportKeyChange
                }),
                error ? _react2.default.createElement(
                    'div',
                    { className: 'error' },
                    error
                ) : null
            ),
            _react2.default.createElement(
                'td',
                { className: 'requires-non-failing', headers: 'requires-non-failing' },
                _react2.default.createElement(
                    'select',
                    {
                        className: 'select',
                        id: 'input-requires-non-failing',
                        onBlur: onRequiresNonFailingChange,
                        onChange: onRequiresNonFailingChange,
                        value: mustPass
                    },
                    _react2.default.createElement(
                        'option',
                        { value: true },
                        _aui.I18n.getText('bitbucket.codeinsights.mergecheck.mustpass.true')
                    ),
                    _react2.default.createElement(
                        'option',
                        { value: false },
                        _aui.I18n.getText('bitbucket.codeinsights.mergecheck.mustpass.false')
                    )
                )
            ),
            _react2.default.createElement(
                'td',
                { headers: 'min-disallowed-sevs' },
                _react2.default.createElement(
                    'select',
                    {
                        className: 'select',
                        id: 'input-min-disallowed-sevs',
                        onBlur: onMinSeverityChange,
                        onChange: onMinSeverityChange,
                        value: minProhibitedSeverity
                    },
                    _react2.default.createElement(
                        'option',
                        { value: SeverityCodes.LOW },
                        SeverityStrings.LOW
                    ),
                    _react2.default.createElement(
                        'option',
                        { value: SeverityCodes.MEDIUM },
                        SeverityStrings.MEDIUM
                    ),
                    _react2.default.createElement(
                        'option',
                        { value: SeverityCodes.HIGH },
                        SeverityStrings.HIGH
                    ),
                    _react2.default.createElement(
                        'option',
                        { value: SeverityCodes.ALLOW_ALL },
                        SeverityStrings.ALLOW_ALL
                    )
                )
            ),
            _react2.default.createElement(
                'td',
                { className: 'actions', headers: 'actions' },
                _react2.default.createElement(
                    'button',
                    { type: 'button', onClick: addSetting, className: 'aui-button' },
                    _aui.I18n.getText('bitbucket.codeinsights.mergecheck.add')
                )
            )
        );
    }
});