/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest.commit;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.codeinsights.annotation.BulkAddInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.DeleteAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotationService;
import com.atlassian.bitbucket.codeinsights.annotation.SearchAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.SetInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.annotation.SingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.codeinsights.report.DeleteInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.GetInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.InsightDataType;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightReportService;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.codeinsights.report.SearchInsightReportRequest;
import com.atlassian.bitbucket.codeinsights.report.SetInsightReportRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.rest.AbstractInsightResource;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestBulkAddInsightAnnotationRequest;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReport;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReportData;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestSetInsightReportRequest;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestSingleAddInsightAnnotationRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}")
public class CommitInsightResource
extends AbstractInsightResource {
    private final InsightAnnotationService insightAnnotationService;
    private final InsightReportService insightReportService;
    private final Validator validator;

    public CommitInsightResource(I18nService i18nService, InsightReportService insightReportService, InsightAnnotationService insightAnnotationService, Validator validator) {
        super(i18nService);
        this.insightReportService = insightReportService;
        this.insightAnnotationService = insightAnnotationService;
        this.validator = validator;
    }

    @POST
    @Path(value="reports/{key}/annotations")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response addAnnotations(@Context Repository repository, @PathParam(value="commitId") String commitId, @PathParam(value="key") String reportKey, RestBulkAddInsightAnnotationRequest request, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.validatePathParams(commitId, reportKey);
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        GetInsightReportRequest getReportRequest = new GetInsightReportRequest.Builder(repository, commitId, reportKey).build();
        Optional<Response> result = this.insightReportService.get(getReportRequest).map(report -> {
            this.insightAnnotationService.addAnnotations(new BulkAddInsightAnnotationRequest.Builder((InsightReport)report).annotationRequests((Iterable)request.getAnnotations().stream().map(this::toAnnotationRequest).collect(MoreCollectors.toImmutableList())).build());
            return ResponseFactory.noContent().build();
        });
        return result.orElse(ResponseFactory.notFound().entity((Object)this.noSuchReport(reportKey)).build());
    }

    @DELETE
    @Path(value="reports/{key}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response delete(@Context Repository repository, @PathParam(value="commitId") String commitId, @PathParam(value="key") String key, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.validatePathParams(commitId, key);
        this.insightReportService.delete(new DeleteInsightReportRequest.Builder(repository, commitId, key).build());
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="reports/{key}/annotations")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response deleteAnnotations(@Context Repository repository, @PathParam(value="commitId") String commitId, @PathParam(value="key") String reportKey, @QueryParam(value="externalId") Set<String> externalIds, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.validatePathParams(commitId);
        this.insightAnnotationService.delete(new DeleteAnnotationRequest.Builder(repository, commitId, reportKey).externalIds(externalIds).build());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="reports/{key}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response get(@Context Repository repository, @PathParam(value="commitId") String commitId, @PathParam(value="key") String key, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.validatePathParams(commitId, key);
        return this.insightReportService.get(new GetInsightReportRequest.Builder(repository, commitId, key).build()).map(c -> ResponseFactory.ok((Object)((Object)new RestInsightReport((InsightReport)c))).build()).orElseGet(() -> ResponseFactory.notFound().entity((Object)this.noSuchReport(key)).build());
    }

    @GET
    @Path(value="reports/{key}/annotations")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response getAnnotations(final @Context Repository repository, final @PathParam(value="commitId") String commitId, final @PathParam(value="key") String key, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                SearchAnnotationRequest request = new SearchAnnotationRequest.Builder(repository, commitId).reportKey(key).build();
                CommitInsightResource.this.insightAnnotationService.stream(request, new AbstractInsightResource.RestAnnotationCallback(writer));
            }
        }).build();
    }

    @GET
    @Path(value="annotations")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response getAnnotations(final @Context Repository repository, final @PathParam(value="commitId") String commitId, final @QueryParam(value="externalId") List<String> externalIds, final @QueryParam(value="key") List<String> keys, final @QueryParam(value="path") List<String> paths, final @QueryParam(value="severity") List<AnnotationSeverity> severities, final @QueryParam(value="type") List<AnnotationType> type, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.validatePathParams(commitId);
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                SearchAnnotationRequest request = new SearchAnnotationRequest.Builder(repository, commitId).reportKeys(keys).externalIds(externalIds).severities(severities).paths(paths).types(type).build();
                CommitInsightResource.this.insightAnnotationService.stream(request, new AbstractInsightResource.RestAnnotationCallback(writer));
            }
        }).build();
    }

    @GET
    @Path(value="reports")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response getReports(@Context Repository repository, @PathParam(value="commitId") String commitId, @Context PageRequest pageRequest, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.validatePathParams(commitId);
        Page<InsightReport> reports = this.insightReportService.search(new SearchInsightReportRequest.Builder(repository, commitId).build(), pageRequest);
        return ResponseFactory.ok((Object)new RestPage(reports, RestInsightReport::new)).build();
    }

    @PUT
    @Path(value="reports/{key}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response set(@Context Repository repository, @PathParam(value="commitId") String commitId, @PathParam(value="key") String key, RestSetInsightReportRequest request, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.validatePathParams(commitId, key);
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        return ResponseFactory.ok((Object)((Object)new RestInsightReport(this.insightReportService.set(new SetInsightReportRequest.Builder(repository, commitId, key, request.getTitle()).coverageProviderKey(request.getCoverageProviderKey()).data((List)request.getData().stream().map(this::toInsightData).collect(MoreCollectors.toImmutableList())).details(request.getDetails()).link(this.toURI(request.getLink(), "bitbucket.rest.codeinsights.error.link.url")).logoUrl(this.toURI(request.getLogoUrl(), "bitbucket.rest.codeinsights.error.logo-url.url")).result(this.toResult(request.getResult())).reporter(request.getReporter()).build())))).build();
    }

    @PUT
    @Path(value="reports/{key}/annotations/{externalId}")
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    public Response setAnnotation(@Context Repository repository, @PathParam(value="commitId") String commitId, @PathParam(value="key") String reportKey, @PathParam(value="externalId") String externalId, RestSingleAddInsightAnnotationRequest request, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repoSlug) {
        this.validatePathParams(commitId, reportKey, externalId);
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        GetInsightReportRequest getReportRequest = new GetInsightReportRequest.Builder(repository, commitId, reportKey).build();
        Optional<Response> result = this.insightReportService.get(getReportRequest).map(report -> {
            this.insightAnnotationService.set(new SetInsightAnnotationRequest.Builder((InsightReport)report, this.toAnnotationRequest(request, externalId)).build());
            return ResponseFactory.noContent().build();
        });
        return result.orElse(ResponseFactory.notFound().entity((Object)this.noSuchReport(reportKey)).build());
    }

    private SingleAddInsightAnnotationRequest toAnnotationRequest(RestSingleAddInsightAnnotationRequest annotation) {
        return this.toAnnotationRequest(annotation, annotation.getExternalId());
    }

    private SingleAddInsightAnnotationRequest toAnnotationRequest(RestSingleAddInsightAnnotationRequest annotation, String externalId) {
        return new SingleAddInsightAnnotationRequest.Builder(annotation.getLine(), annotation.getMessage(), annotation.getPath()).externalId(externalId).link(this.toURI(annotation.getLink(), "bitbucket.rest.codeinsights.annotation.error.link.url")).severity(AnnotationSeverity.valueOf(annotation.getSeverity())).type(annotation.getType() == null ? null : AnnotationType.valueOf(annotation.getType())).build();
    }

    private InsightReportData toInsightData(RestInsightReportData restData) {
        InsightReportData.Builder builder = new InsightReportData.Builder(restData.getTitle(), restData.getValue());
        String format = restData.getType();
        if (format != null) {
            builder.type(InsightDataType.valueOf(format));
        }
        return builder.build();
    }

    private InsightResult toResult(String result) {
        if (result == null) {
            return null;
        }
        return InsightResult.valueOf(result.toUpperCase(Locale.ROOT));
    }

    private void validatePathParams(String commitId) {
        if (!ShaUtils.isHash((String)commitId)) {
            throw new BadRequestException("commitId", this.i18nService.getMessage("bitbucket.codeinsights.error.commitId", new Object[0]));
        }
    }

    private void validatePathParams(String commitId, String reportKey) {
        this.validatePathParams(commitId);
        if (StringUtils.length((CharSequence)reportKey) > 50) {
            throw new BadRequestException("key", this.i18nService.getMessage("bitbucket.rest.codeinsights.error.key.length", new Object[0]));
        }
    }

    private void validatePathParams(String commitId, String reportKey, String externalId) {
        this.validatePathParams(commitId, reportKey);
        if (StringUtils.isBlank((CharSequence)externalId)) {
            throw new BadRequestException("externalId", this.i18nService.getMessage("bitbucket.rest.codeinsights.annotation.error.update.externalid", new Object[0]));
        }
    }
}

