/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.coverage.CodeCoverage;
import com.atlassian.bitbucket.internal.codeinsights.coverage.InvalidCallbackMethodException;
import com.atlassian.bitbucket.internal.codeinsights.rest.PagedCodeCoverageCallback;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class JsonCodeCoverageCallback
implements PagedCodeCoverageCallback {
    private final PageRequest pageRequest;
    private final StatefulJsonWriter writer;
    private boolean isStarted;
    private int size;

    public JsonCodeCoverageCallback(StatefulJsonWriter writer, PageRequest pageRequest) {
        this.pageRequest = Objects.requireNonNull(pageRequest, "pageRequest");
        this.writer = Objects.requireNonNull(writer, "writer");
    }

    @Override
    public void end() {
        boolean isLastPage = this.size <= this.pageRequest.getLimit();
        try {
            this.writer.endArray().name("size").value((long)this.size).name("isLastPage").value(isLastPage).name("start").value((long)this.pageRequest.getStart()).name("limit").value((long)this.pageRequest.getLimit()).name("nextPageStart");
            if (isLastPage || this.pageRequest.getLimit() > this.size) {
                this.writer.nullValue();
            } else {
                this.writer.value((long)(this.pageRequest.getStart() + this.pageRequest.getLimit()));
            }
            this.writer.endObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write response", e);
        }
    }

    @Override
    public void onFileEnd() {
        if (!this.isStarted) {
            throw new InvalidCallbackMethodException("onFileEnd called without onFileStart");
        }
        try {
            this.writer.endArray().endObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write response", e);
        }
        this.isStarted = false;
    }

    @Override
    public void onFileStart(String reportKey, String fileCoverageUrl, String path) {
        Objects.requireNonNull(reportKey, "reportKey");
        Objects.requireNonNull(fileCoverageUrl, "fileCoverageUrl");
        Objects.requireNonNull(path, "path");
        this.isStarted = true;
        ++this.size;
        try {
            this.writer.beginObject().name("reportKey").value(reportKey);
            if (StringUtils.isNotBlank((CharSequence)fileCoverageUrl)) {
                this.writer.name("fileCoverageUrl").value(fileCoverageUrl);
            }
            this.writer.name("path").value(path).name("ranges").beginArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write response", e);
        }
    }

    @Override
    public void onRange(CodeCoverage coverage) {
        Objects.requireNonNull(coverage, "coverage");
        if (!this.isStarted) {
            throw new InvalidCallbackMethodException("onRange called without onFileStart");
        }
        try {
            this.writer.beginArray().value((long)coverage.getStart()).value((long)coverage.getEnd()).value(coverage.getCodeCoverageLevel().getId());
            if (coverage.getMessage().isPresent()) {
                this.writer.value(coverage.getMessage().get());
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write response", e);
        }
    }

    @Override
    public void start() {
        try {
            this.writer.beginObject().name("values").beginArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write response", e);
        }
    }
}

