define('bitbucket-plugin-code-insights/internal/summary-link/summary-link', ['module', 'exports', '@atlassian/aui', 'classnames', 'prop-types', 'react', 'bitbucket/internal/util/dom-event', 'bitbucket/internal/util/text', 'bitbucket/internal/widget/icons/icons', '../analytics', '../report'], function (module, exports, _aui, _classnames, _propTypes, _react, _domEvent, _text, _icons, _analytics, _report) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _analytics2 = _interopRequireDefault(_analytics);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var resultTitle = function resultTitle(result, count) {
        var _ResultEnum$FAIL$Resu;

        return (_ResultEnum$FAIL$Resu = {}, _defineProperty(_ResultEnum$FAIL$Resu, _report.ResultEnum.FAIL, _aui.I18n.getText('bitbucket.codeinsights.summary.tooltip.failed', count)), _defineProperty(_ResultEnum$FAIL$Resu, _report.ResultEnum.PASS, _aui.I18n.getText('bitbucket.codeinsights.summary.tooltip.passed', count)), _defineProperty(_ResultEnum$FAIL$Resu, 'null', null), _ResultEnum$FAIL$Resu)[result] || '';
    };

    var summaryLabel = function summaryLabel(reportCount, onlyReport) {
        if (!reportCount) {
            return _aui.I18n.getText('bitbucket.codeinsights.summary.add.integration');
        } else if (reportCount === 1) {
            return onlyReport.title;
        } else {
            return _react2.default.createElement('span', {
                dangerouslySetInnerHTML: {
                    __html: _aui.I18n.getText('bitbucket.codeinsights.summary.label.html', (0, _text.capInt)(reportCount, 10))
                }
            });
        }
    };

    var SummaryLink = function (_PureComponent) {
        _inherits(SummaryLink, _PureComponent);

        function SummaryLink() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, SummaryLink);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = SummaryLink.__proto__ || Object.getPrototypeOf(SummaryLink)).call.apply(_ref, [this].concat(args))), _this), _this.onClick = function (e) {
                var _this$props = _this.props,
                    onlyReport = _this$props.onlyReport,
                    result = _this$props.result,
                    reportCount = _this$props.reportCount;


                if (!onlyReport || !onlyReport.link || (0, _domEvent.openInSameTab)(e)) {
                    e.preventDefault();
                    _this.props.onClick({ reportCount: reportCount });
                    (0, _analytics2.default)('stash.client.codeinsights.overview.report.list.opened', {
                        'has.failures': result === _report.ResultEnum.FAIL,
                        'report.count': reportCount
                    });
                }
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(SummaryLink, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.updateClassNames();
                this._setContainerTitle();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps) {
                var _props = this.props,
                    result = _props.result,
                    resultCount = _props.resultCount,
                    className = _props.className,
                    reportCount = _props.reportCount;


                if (result !== prevProps.result || resultCount !== prevProps.resultCount) {
                    this._setContainerTitle();
                }

                if (className !== prevProps.className || reportCount === 0 !== (prevProps.reportCount === 0)) {
                    this.updateClassNames();
                }
            }
        }, {
            key: '_setContainerTitle',
            value: function _setContainerTitle() {
                var _props2 = this.props,
                    result = _props2.result,
                    resultCount = _props2.resultCount,
                    containerEl = _props2.containerEl;

                containerEl.title = resultTitle(result, resultCount);
            }
        }, {
            key: 'updateClassNames',
            value: function updateClassNames() {
                var _props3 = this.props,
                    reportCount = _props3.reportCount,
                    containerEl = _props3.containerEl,
                    className = _props3.className;


                if (reportCount === 0) {
                    containerEl.className = className;
                } else {
                    containerEl.className = (0, _classnames2.default)('plugin-item', className);
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props4 = this.props,
                    onlyReport = _props4.onlyReport,
                    reportCount = _props4.reportCount,
                    result = _props4.result;

                var link = onlyReport && onlyReport.link;

                if (reportCount === 0) {
                    return null;
                }

                var label = summaryLabel(reportCount, onlyReport);
                var labelJSX = _react2.default.createElement(
                    'span',
                    { className: 'code-insights-summary-label' },
                    summaryLabel(reportCount, onlyReport)
                );

                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    link ? _react2.default.createElement(
                        'a',
                        { href: link, onClick: this.onClick, title: label },
                        _react2.default.createElement(_icons.AddonIcon, null),
                        labelJSX
                    ) : _react2.default.createElement(
                        'button',
                        {
                            type: 'button',
                            className: 'aui-button aui-button-link',
                            onClick: this.onClick
                        },
                        _react2.default.createElement(_icons.AddonIcon, null),
                        labelJSX
                    ),
                    result === _report.ResultEnum.FAIL && _react2.default.createElement(
                        'div',
                        { className: 'item-extra-content' },
                        _react2.default.createElement(
                            _icons.FailedBuildIcon,
                            null,
                            _aui.I18n.getText('bitbucket.codeinsights.summary.failures')
                        )
                    )
                );
            }
        }]);

        return SummaryLink;
    }(_react.PureComponent);

    SummaryLink.propTypes = {
        containerEl: _propTypes2.default.object.isRequired,
        className: _propTypes2.default.string,
        onClick: _propTypes2.default.func.isRequired,
        // Redux
        reportCount: _propTypes2.default.number.isRequired,
        onlyReport: _propTypes2.default.shape({
            link: _propTypes2.default.string,
            title: _propTypes2.default.string.isRequired
        }),
        result: _propTypes2.default.oneOf([_report.ResultEnum.PASS, _report.ResultEnum.FAIL, null]),
        resultCount: _propTypes2.default.number.isRequired
    };
    exports.default = SummaryLink;
    module.exports = exports['default'];
});