define('bitbucket-plugin-code-insights/internal/report-inline-dialog/report-inline-dialog', ['module', 'exports', '@atlassian/aui', 'lodash', 'react', 'bitbucket/internal/bbui/aui-react/inline-dialog', 'bitbucket/internal/bbui/aui-react/toggle-button', 'bitbucket/internal/bbui/tipsy/tipsy', '../annotation-table/reporter-logo', '../insight-preferences'], function (module, exports, _aui, _lodash, _react, _inlineDialog, _toggleButton, _tipsy, _reporterLogo, _insightPreferences) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _inlineDialog2 = _interopRequireDefault(_inlineDialog);

    var _toggleButton2 = _interopRequireDefault(_toggleButton);

    var _tipsy2 = _interopRequireDefault(_tipsy);

    var _reporterLogo2 = _interopRequireDefault(_reporterLogo);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var ListItem = function ListItem(_ref) {
        var report = _ref.report,
            annotationCount = _ref.annotationCount;

        return _react2.default.createElement(
            'li',
            null,
            _react2.default.createElement(_reporterLogo2.default, { report: report }),
            _react2.default.createElement(
                _tipsy2.default,
                {
                    className: 'report-title',
                    tooltipClassName: 'insights-info-report-title-tooltip',
                    title: report.title || report.reporter,
                    hoverable: false,
                    condition: _tipsy2.default.isTruncatedCondition
                },
                report.title
            ),
            _react2.default.createElement(
                'aui-badge',
                {
                    title: _aui.I18n.getText('bitbucket.codeinsights.report.list.annotation.count', annotationCount)
                },
                annotationCount
            )
        );
    };

    var ReportInlineDialog = function (_Component) {
        _inherits(ReportInlineDialog, _Component);

        function ReportInlineDialog() {
            var _ref2;

            var _temp, _this, _ret;

            _classCallCheck(this, ReportInlineDialog);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref2 = ReportInlineDialog.__proto__ || Object.getPrototypeOf(ReportInlineDialog)).call.apply(_ref2, [this].concat(args))), _this), _this.state = {
                changedLinesOnly: ReportInlineDialog.getChangedLinesOnly()
            }, _this.toggleChangedLinesOnly = function (enabled) {
                _this.setState({
                    changedLinesOnly: enabled
                });
                (0, _insightPreferences.toggleChangedLinesOnlySetting)(enabled);
                _this.props.setChangedLinesOnly(enabled);
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(ReportInlineDialog, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    infoDialogId = _props.infoDialogId,
                    reportsByKey = _props.reportsByKey,
                    annotations = _props.annotations;

                var list = void 0;

                if ((0, _lodash.get)(annotations, 'length')) {
                    var countByReportKey = (0, _lodash.countBy)(annotations, 'reportKey');
                    list = Object.values(reportsByKey).sort(function (reportA, reportB) {
                        return reportA.title.localeCompare(reportB.title);
                    }).filter(function (report) {
                        return countByReportKey[report.key];
                    }).map(function (report) {
                        return _react2.default.createElement(ListItem, {
                            key: report.key,
                            report: report,
                            annotationCount: countByReportKey[report.key]
                        });
                    });
                }

                return _react2.default.createElement(
                    _inlineDialog2.default,
                    {
                        id: infoDialogId,
                        className: infoDialogId + ' report-list-dialog',
                        alignment: 'bottom center'
                    },
                    _react2.default.createElement(
                        'h5',
                        null,
                        'Annotations'
                    ),
                    _react2.default.createElement(
                        'ul',
                        { className: 'info-dialog-report-list' },
                        list
                    ),
                    _react2.default.createElement(
                        'h5',
                        null,
                        _aui.I18n.getText('bitbucket.codeinsights.annotation.diff.settings.title')
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'annotation-toggle-setting field-group' },
                        _react2.default.createElement(
                            'label',
                            { htmlFor: 'changed-lines-only' },
                            _aui.I18n.getText('bitbucket.codeinsights.annotation.location.toggle')
                        ),
                        _react2.default.createElement(_toggleButton2.default, {
                            id: 'changed-lines-only',
                            checked: this.state.changedLinesOnly,
                            label: _aui.I18n.getText('bitbucket.codeinsights.annotation.location.toggle'),
                            onToggle: this.toggleChangedLinesOnly
                        })
                    )
                );
            }
        }], [{
            key: 'getChangedLinesOnly',
            value: function getChangedLinesOnly() {
                return (0, _insightPreferences.getChangedLinesOnlySetting)();
            }
        }]);

        return ReportInlineDialog;
    }(_react.Component);

    exports.default = ReportInlineDialog;
    module.exports = exports['default'];
});