define('bitbucket-plugin-code-insights/internal/pull-request-diff/insights-toolbar-button', ['module', 'exports', '@atlassian/aui', 'classnames', 'lodash', 'react', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/widget/icons/icons', '../analytics'], function (module, exports, _aui, _classnames, _lodash, _react, _spinner, _icons, _analytics) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _spinner2 = _interopRequireDefault(_spinner);

    var _analytics2 = _interopRequireDefault(_analytics);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var InsightsButton = function (_Component) {
        _inherits(InsightsButton, _Component);

        function InsightsButton() {
            _classCallCheck(this, InsightsButton);

            return _possibleConstructorReturn(this, (InsightsButton.__proto__ || Object.getPrototypeOf(InsightsButton)).apply(this, arguments));
        }

        _createClass(InsightsButton, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    visible = _props.visible,
                    loading = _props.loading,
                    outdated = _props.outdated,
                    annotations = _props.annotations,
                    infoDialogId = _props.infoDialogId,
                    _props$reportsByKey = _props.reportsByKey,
                    reportsByKey = _props$reportsByKey === undefined ? {} : _props$reportsByKey,
                    annotationsTruncated = _props.annotationsTruncated;

                var hasAnnotations = annotations && annotations.length > 0;
                var iconProps = {
                    tooltip: true,
                    offset: 7,
                    gravity: 'ne'
                };

                if (!hasAnnotations) {
                    iconProps.title = _aui.I18n.getText('bitbucket.codeinsights.diff.insights.button.no.annotations');
                    if (annotationsTruncated) {
                        iconProps.title = _aui.I18n.getText('bitbucket.codeinsights.diff.insights.button.truncated.annotations');
                        (0, _analytics2.default)('stash.client.codeinsights.pullrequest.diff.annotations.truncated');
                    }
                } else {
                    var reportCount = (0, _lodash.chain)(annotations).countBy('reportKey').keys().intersection(Object.keys(reportsByKey)).size().value();
                    iconProps.title = _aui.I18n.getText('bitbucket.codeinsights.diff.insights.button.report.count', reportCount);
                    // make sure there is a report count before firing analytics.
                    // annotations and reports come in separately so check here to avoid double-requesting
                    if (reportCount) {
                        (0, _analytics2.default)('stash.client.codeinsights.pullrequest.diff.annotations.loaded', {
                            'report.count': reportCount,
                            'annotations.count': annotations.length,
                            'annotations.outdated': outdated
                        });
                    }
                }

                // N.B. the data-aui-trigger attribute should always remain present so that AUI / Skate
                // will correctly resolve this as a trigger
                return _react2.default.createElement(
                    'button',
                    {
                        disabled: !hasAnnotations,
                        className: (0, _classnames2.default)('aui-button', 'aui-button-subtle', 'code-insights-button', {
                            'annotations-outdated': outdated,
                            'annotations-off': !visible,
                            loading: loading
                        }),
                        'data-aui-trigger': true,
                        'aria-controls': infoDialogId
                    },
                    loading ? _react2.default.createElement(_spinner2.default, null) : _react2.default.createElement(_icons.AddonIcon, iconProps)
                );
            }
        }]);

        return InsightsButton;
    }(_react.Component);

    InsightsButton.defaultProps = {
        visible: true,
        changedLinesOnly: true,
        loading: false,
        annotations: []
    };

    exports.default = InsightsButton;
    module.exports = exports['default'];
});