define('bitbucket-plugin-code-insights/internal/outdated-annotations/outdated-annotations', ['module', 'exports', '@atlassian/aui', 'lodash', 'react', 'bitbucket/internal/bbui/aui-react/dialog', 'bitbucket/internal/bbui/aui-react/inline-dialog', '../analytics', '../annotation-table/annotation-table'], function (module, exports, _aui, _lodash, _react, _dialog, _inlineDialog, _analytics, _annotationTable) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _dialog2 = _interopRequireDefault(_dialog);

    var _inlineDialog2 = _interopRequireDefault(_inlineDialog);

    var _analytics2 = _interopRequireDefault(_analytics);

    var _annotationTable2 = _interopRequireDefault(_annotationTable);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var OutdatedAnnotations = function (_Component) {
        _inherits(OutdatedAnnotations, _Component);

        function OutdatedAnnotations() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, OutdatedAnnotations);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = OutdatedAnnotations.__proto__ || Object.getPrototypeOf(OutdatedAnnotations)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                dialogOpen: false
            }, _this.showOutdatedDialog = function (e) {
                var _this$props = _this.props,
                    annotations = _this$props.annotations,
                    reportsByKey = _this$props.reportsByKey;

                _this.setState({ dialogOpen: true });
                (0, _analytics2.default)('stash.client.codeinsights.pullrequest.diff.outdated.dialog.opened', {
                    'annotations.count': annotations.length,
                    'report.count': Object.keys(reportsByKey).length
                });
            }, _this.onCloseDialog = function () {
                _this.setState({ dialogOpen: false });
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(OutdatedAnnotations, [{
            key: 'componentWillMount',
            value: function componentWillMount() {
                this.inlineDialog = document.getElementById(this.props.infoDialogId);
            }
        }, {
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                this.inlineDialog = document.getElementById(this.props.infoDialogId);
                (0, _lodash.defer)(function () {
                    if (_this2.props.showInfoDialog) {
                        _this2.inlineDialog.open = true;
                    }
                });
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                if (this.state.dialogOpen) {
                    this.inlineDialog.open = false;
                }
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                this.inlineDialog.parentNode.removeChild(this.inlineDialog);
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    annotations = _props.annotations,
                    reportsByKey = _props.reportsByKey,
                    infoDialogId = _props.infoDialogId,
                    pullRequest = _props.pullRequest;

                var fileName = annotations[0].path;

                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    _react2.default.createElement(
                        _inlineDialog2.default,
                        {
                            id: infoDialogId,
                            className: infoDialogId + ' outdated-annotations-warning',
                            alignment: 'bottom center'
                        },
                        _react2.default.createElement(
                            'h5',
                            null,
                            _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.info.title')
                        ),
                        _react2.default.createElement(
                            'p',
                            { className: 'warning' },
                            _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.info.content'),
                            ' ',
                            _react2.default.createElement(
                                'a',
                                {
                                    href: bitbucket_help_url('bitbucket.go.code.insights.outdated.learn.more'),
                                    target: '_blank'
                                },
                                _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.info.learn.more')
                            )
                        ),
                        _react2.default.createElement(
                            'p',
                            { className: 'actions' },
                            _react2.default.createElement(
                                'button',
                                {
                                    className: 'aui-button see-outdated-annotations',
                                    onClick: this.showOutdatedDialog
                                },
                                _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.info.see.outdated')
                            )
                        )
                    ),
                    this.state.dialogOpen && _react2.default.createElement(
                        _dialog2.default,
                        {
                            onClose: this.onCloseDialog,
                            size: _dialog.DialogSize.XLARGE,
                            titleContent: _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.title'),
                            className: 'outdated-annotations-dialog'
                        },
                        _react2.default.createElement(
                            'p',
                            null,
                            _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.analysis.before', fileName)
                        ),
                        _react2.default.createElement(_annotationTable2.default, {
                            annotations: annotations,
                            pullRequest: pullRequest,
                            reportsByKey: reportsByKey,
                            Columns: [_annotationTable.ReporterColumn, _annotationTable.SeverityColumn, _annotationTable.TypeColumn, _annotationTable.MessageColumn, _annotationTable.LineColumn]
                        })
                    )
                );
            }
        }]);

        return OutdatedAnnotations;
    }(_react.Component);

    exports.default = OutdatedAnnotations;
    module.exports = exports['default'];
});