define('bitbucket-plugin-code-insights/internal/list-and-detail/list-and-detail', ['module', 'exports', 'prop-types', 'react', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/util/get-id'], function (module, exports, _propTypes, _react, _reactFunctional, _getId) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var DefaultMenuItem = (0, _reactFunctional.pure)(function (_ref) {
        var title = _ref.item.title;
        return title;
    });

    var Item = function (_PureComponent) {
        _inherits(Item, _PureComponent);

        function Item() {
            var _ref2;

            var _temp, _this, _ret;

            _classCallCheck(this, Item);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref2 = Item.__proto__ || Object.getPrototypeOf(Item)).call.apply(_ref2, [this].concat(args))), _this), _this.onClick = function (e) {
                e.preventDefault();
                _this.props.onClick(_this.props.item);
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(Item, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    selected = _props.selected,
                    item = _props.item,
                    menuItem = _props.menuItem;


                return _react2.default.createElement(
                    'li',
                    { className: selected ? 'selected' : null },
                    _react2.default.createElement(
                        'button',
                        { type: 'button', onClick: this.onClick },
                        menuItem({ item: item })
                    )
                );
            }
        }]);

        return Item;
    }(_react.PureComponent);

    var ListAndDetailView = function (_PureComponent2) {
        _inherits(ListAndDetailView, _PureComponent2);

        function ListAndDetailView() {
            var _ref3;

            var _temp2, _this2, _ret2;

            _classCallCheck(this, ListAndDetailView);

            for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                args[_key2] = arguments[_key2];
            }

            return _ret2 = (_temp2 = (_this2 = _possibleConstructorReturn(this, (_ref3 = ListAndDetailView.__proto__ || Object.getPrototypeOf(ListAndDetailView)).call.apply(_ref3, [this].concat(args))), _this2), _this2.state = {}, _this2.onItemSelected = function (selectedItem) {
                _this2.setState({
                    selectedId: (0, _getId.getId)(_this2.props.idKey)(selectedItem)
                });
            }, _temp2), _possibleConstructorReturn(_this2, _ret2);
        }

        _createClass(ListAndDetailView, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.notifyThatItemWasSelected();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps, prevState) {
                if (prevState.selectedId !== this.state.selectedId) {
                    this.notifyThatItemWasSelected();
                }
            }
        }, {
            key: 'notifyThatItemWasSelected',
            value: function notifyThatItemWasSelected() {
                var _this3 = this;

                var _props2 = this.props,
                    items = _props2.items,
                    idKey = _props2.idKey,
                    onItemSelected = _props2.onItemSelected;


                if (onItemSelected) {
                    var getId = (0, _getId.getId)(idKey);
                    var selectedItem = items.find(function (item) {
                        return getId(item) === _this3.state.selectedId;
                    });

                    this.props.onItemSelected(selectedItem);
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _this4 = this;

                var _props3 = this.props,
                    items = _props3.items,
                    idKey = _props3.idKey,
                    _props3$menuItem = _props3.menuItem,
                    menuItem = _props3$menuItem === undefined ? DefaultMenuItem : _props3$menuItem,
                    detail = _props3.detail;
                var selectedId = this.state.selectedId;

                var getId = (0, _getId.getId)(idKey);
                var selectedItem = void 0;
                var selectedItemIndex = void 0;

                return _react2.default.createElement(
                    'div',
                    { className: 'list-and-detail' },
                    _react2.default.createElement(
                        'ul',
                        { className: 'list' },
                        items.map(function (item, index) {
                            var id = getId(item);
                            var isSelected = id === selectedId;

                            if (isSelected) {
                                selectedItem = item;
                                selectedItemIndex = index;
                            }

                            return _react2.default.createElement(Item, {
                                key: id,
                                selected: isSelected,
                                item: item,
                                menuItem: menuItem,
                                onClick: _this4.onItemSelected
                            });
                        })
                    ),
                    _react2.default.createElement(
                        'section',
                        { className: 'detail' },
                        selectedItem && detail({ item: selectedItem, index: selectedItemIndex })
                    )
                );
            }
        }], [{
            key: 'getDerivedStateFromProps',
            value: function getDerivedStateFromProps(_ref4, _ref5) {
                var items = _ref4.items,
                    idKey = _ref4.idKey;
                var selectedId = _ref5.selectedId;

                var getId = (0, _getId.getId)(idKey);
                var selectedItem = selectedId && items.find(function (item) {
                    return getId(item) === selectedId;
                });

                if (!selectedItem && items && items.length) {
                    return {
                        selectedId: getId(items[0])
                    };
                }

                return null;
            }
        }]);

        return ListAndDetailView;
    }(_react.PureComponent);

    ListAndDetailView.propTypes = {
        onItemSelected: _propTypes2.default.func,
        items: _propTypes2.default.array.isRequired,
        menuItem: _propTypes2.default.func.isRequired,
        detail: _propTypes2.default.func.isRequired
    };
    ListAndDetailView.defaultProps = {
        idKey: 'id'
    };
    exports.default = ListAndDetailView;
    module.exports = exports['default'];
});