define('bitbucket-plugin-code-insights/internal/annotation/annotation', ['exports', '@atlassian/aui', 'classnames', 'prop-types', 'react', 'bitbucket/internal/widget/icons/icons', '../analytics'], function (exports, _aui, _classnames, _propTypes, _react, _icons, _analytics) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.AnnotationType = exports.SeverityIcon = exports.SeverityLevel = exports.Severity = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _analytics2 = _interopRequireDefault(_analytics);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _severityLevelMap, _severityIconMap;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var Severity = exports.Severity = {
        LOW: 'LOW',
        MEDIUM: 'MEDIUM',
        HIGH: 'HIGH'
    };

    var severityLevelMap = (_severityLevelMap = {}, _defineProperty(_severityLevelMap, Severity.LOW, _aui.I18n.getText('bitbucket.codeinsights.annotation.severity.low')), _defineProperty(_severityLevelMap, Severity.MEDIUM, _aui.I18n.getText('bitbucket.codeinsights.annotation.severity.medium')), _defineProperty(_severityLevelMap, Severity.HIGH, _aui.I18n.getText('bitbucket.codeinsights.annotation.severity.high')), _severityLevelMap);

    var SeverityLevel = exports.SeverityLevel = function SeverityLevel(_ref) {
        var severity = _ref.severity;
        return severityLevelMap[severity];
    };
    SeverityLevel.propTypes = {
        severity: _propTypes2.default.string.isRequired
    };

    var severityIconMap = (_severityIconMap = {}, _defineProperty(_severityIconMap, Severity.LOW, _icons.ChevronUpIcon), _defineProperty(_severityIconMap, Severity.MEDIUM, _icons.ChevronDoubleUpIcon), _defineProperty(_severityIconMap, Severity.HIGH, _icons.ChevronTripleUpIcon), _severityIconMap);

    var SeverityIcon = exports.SeverityIcon = function SeverityIcon(_ref2) {
        var severity = _ref2.severity;

        var Icon = severityIconMap[severity];

        return _react2.default.createElement(Icon, { className: 'severity severity-' + severity.toLowerCase() });
    };
    SeverityIcon.propTypes = {
        severity: _propTypes2.default.string.isRequired
    };

    var AnnotationTypeMap = {
        BUG: _aui.I18n.getText('bitbucket.codeinsights.annotation.type.bug'),
        CODE_SMELL: _aui.I18n.getText('bitbucket.codeinsights.annotation.type.code.smell'),
        VULNERABILITY: _aui.I18n.getText('bitbucket.codeinsights.annotation.type.vulnerability')
    };

    var AnnotationType = exports.AnnotationType = function AnnotationType(_ref3) {
        var type = _ref3.type,
            suffix = _ref3.suffix;

        if (!type) {
            return null;
        }
        var mappedType = AnnotationTypeMap[type];

        return mappedType != null && _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(
                'span',
                { className: 'annotation-type' },
                mappedType
            ),
            suffix
        );
    };
    AnnotationType.propTypes = {
        type: _propTypes2.default.string,
        suffix: _propTypes2.default.string
    };

    function annotationReporterLinkClicked(annotation, report) {
        (0, _analytics2.default)('stash.client.codeinsights.annotation.reporter.link.clicked', {
            'annotation.severity': annotation.severity,
            'annotation.type': annotation.type,
            'report.result': report.result
        });
    }

    var Annotation = function Annotation(_ref4) {
        var annotation = _ref4.annotation,
            report = _ref4.report;
        return _react2.default.createElement(
            'div',
            { className: (0, _classnames2.default)('annotation', 'severity-' + annotation.severity.toLowerCase()) },
            _react2.default.createElement(SeverityIcon, { severity: annotation.severity }),
            _react2.default.createElement(
                'span',
                { className: 'annotation-details' },
                _react2.default.createElement(
                    'span',
                    { className: 'annotation-severity' },
                    _react2.default.createElement(SeverityLevel, { severity: annotation.severity })
                ),
                '-',
                _react2.default.createElement(AnnotationType, { type: annotation.type, suffix: '-' }),
                _react2.default.createElement(
                    'span',
                    { className: 'annotation-message' },
                    annotation.message
                )
            ),
            annotation.link && report && _react2.default.createElement(
                'a',
                {
                    href: annotation.link,
                    className: 'annotation-link',
                    target: '_blank',
                    rel: 'noopener noreferrer',
                    onClick: function onClick() {
                        return annotationReporterLinkClicked(annotation, report);
                    }
                },
                _aui.I18n.getText('bitbucket.codeinsights.annotation.view.on.report', report.reporter || report.title)
            )
        );
    };

    Annotation.propTypes = {
        annotation: _propTypes2.default.object.isRequired
    };

    exports.default = Annotation;
});