/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.rest.RestMapEntity;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class RestSingleAddInsightAnnotationRequest
extends RestMapEntity {
    public static final RestSingleAddInsightAnnotationRequest EXAMPLE = new RestSingleAddInsightAnnotationRequest("message-1", 4, "https://link.to.tool/that/produced/annotation/message-1", "This is a bug here because reasons", "path/to/file/in/repo", AnnotationSeverity.MEDIUM, AnnotationType.CODE_SMELL);
    public static final RestSingleAddInsightAnnotationRequest EXAMPLE_FILE_ANNOTATION = new RestSingleAddInsightAnnotationRequest("file-annotation-1", 0, "https://link.to.tool/that/produced/annotation/file-annotation-1", "This whole file needs to be annotated", "path/to/file/in/repo", AnnotationSeverity.LOW, AnnotationType.VULNERABILITY);
    public static final RestSingleAddInsightAnnotationRequest EXAMPLE_MINIMAL = new RestSingleAddInsightAnnotationRequest(null, 2, null, "This is a vulnerability, but I don't need to access it again so I haven't given it an external ID", "path/to/another/file/in/repo", AnnotationSeverity.HIGH, null);
    public static final String EXTERNAL_ID = "externalId";
    public static final String LINE = "line";
    public static final String LINK = "link";
    public static final String MESSAGE = "message";
    public static final String PATH = "path";
    public static final String SEVERITY = "severity";
    public static final String TYPE = "type";

    public RestSingleAddInsightAnnotationRequest() {
    }

    RestSingleAddInsightAnnotationRequest(Map<String, ?> values) {
        super(values);
    }

    RestSingleAddInsightAnnotationRequest(String externalId, int line, String link, String message, String path, AnnotationSeverity severity, AnnotationType type) {
        this.putIfNotNull(EXTERNAL_ID, externalId);
        this.put(LINE, line);
        this.putIfNotNull(LINK, link);
        this.put(MESSAGE, message);
        this.put(PATH, path);
        this.put(SEVERITY, severity.name());
        if (type != null) {
            this.put(TYPE, type.name());
        }
    }

    @Nullable
    @Size(max=450, message="{bitbucket.codeinsights.error.annotation.ext.id.too.long}")
    public @Size(max=450, message="{bitbucket.codeinsights.error.annotation.ext.id.too.long}") String getExternalId() {
        return this.getStringProperty(EXTERNAL_ID);
    }

    @Min(value=0L, message="{bitbucket.rest.codeinsights.annotation.error.line.min}")
    public @Min(value=0L, message="{bitbucket.rest.codeinsights.annotation.error.line.min}") int getLine() {
        return this.getIntProperty(LINE);
    }

    @Nullable
    public String getLink() {
        return this.getStringProperty(LINK);
    }

    @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.message.required}")
    @Size(max=2000, message="{bitbucket.rest.codeinsights.annotation.error.message.length}")
    public @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.message.required}") @Size(max=2000, message="{bitbucket.rest.codeinsights.annotation.error.message.length}") String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.path.required}")
    @Size(max=50000, message="{bitbucket.rest.codeinsights.annotation.error.path.length}")
    public @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.path.required}") @Size(max=50000, message="{bitbucket.rest.codeinsights.annotation.error.path.length}") String getPath() {
        return this.getStringProperty(PATH);
    }

    @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.severity.required}")
    @Pattern(regexp="LOW|MEDIUM|HIGH", message="{bitbucket.rest.codeinsights.annotation.error.severity.pattern}")
    public @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.severity.required}") @Pattern(regexp="LOW|MEDIUM|HIGH", message="{bitbucket.rest.codeinsights.annotation.error.severity.pattern}") String getSeverity() {
        return this.getStringProperty(SEVERITY);
    }

    @Nullable
    @Pattern(regexp="VULNERABILITY|CODE_SMELL|BUG", message="{bitbucket.rest.codeinsights.annotation.error.type.pattern}")
    public @Pattern(regexp="VULNERABILITY|CODE_SMELL|BUG", message="{bitbucket.rest.codeinsights.annotation.error.type.pattern}") String getType() {
        return this.getStringProperty(TYPE);
    }

    @Nullable
    static RestSingleAddInsightAnnotationRequest valueOf(Object value) {
        if (value instanceof RestSingleAddInsightAnnotationRequest) {
            return (RestSingleAddInsightAnnotationRequest)((Object)value);
        }
        if (value instanceof Map) {
            return new RestSingleAddInsightAnnotationRequest((Map)value);
        }
        return null;
    }
}

