/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.annotation;

import com.atlassian.bitbucket.internal.codeinsights.annotation.LineRange;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public final class ModifiedFile {
    private final String effectivePath;
    private final Set<LineRange> modifiedLines;
    private final boolean outdated;
    private final String path;
    private final boolean truncated;

    private ModifiedFile(Builder builder) {
        this.effectivePath = builder.effectivePath;
        this.modifiedLines = ImmutableSet.copyOf((Collection)builder.modifiedLines);
        this.outdated = builder.outdated;
        this.path = builder.path;
        this.truncated = builder.truncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifiedFile that = (ModifiedFile)o;
        return Objects.equals(this.effectivePath, that.effectivePath) && Objects.equals(this.modifiedLines, that.modifiedLines) && this.outdated == that.outdated && Objects.equals(this.path, that.path) && this.truncated == that.truncated;
    }

    @Nonnull
    public String getEffectivePath() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.effectivePath, this.path});
    }

    @Nonnull
    public Set<LineRange> getModifiedLines() {
        return this.modifiedLines;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hash(this.effectivePath, this.modifiedLines, this.outdated, this.path, this.truncated);
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public String toString() {
        return "ModifiedFile{modifiedLines=" + this.modifiedLines + ", path='" + this.path + '\'' + ", effectivePath='" + this.effectivePath + '\'' + ", outdated='" + this.outdated + '\'' + ", truncated='" + this.truncated + '\'' + '}';
    }

    public static class Builder {
        private final Set<LineRange> modifiedLines;
        private final String path;
        private String effectivePath;
        private boolean outdated;
        private boolean truncated;

        public Builder(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.modifiedLines = new HashSet<LineRange>();
        }

        public Builder addLineRange(LineRange lineRange) {
            this.modifiedLines.add(lineRange);
            return this;
        }

        public Builder lineRanges(Set<LineRange> lineRanges) {
            this.modifiedLines.addAll(lineRanges);
            return this;
        }

        public ModifiedFile build() {
            return new ModifiedFile(this);
        }

        public Builder effectivePath(String effectivePath) {
            this.effectivePath = effectivePath;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public Builder outdated(boolean outdated) {
            this.outdated = outdated;
            return this;
        }

        public Builder truncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }
    }
}

