/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.status;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefMetadataContext;
import com.atlassian.bitbucket.repository.RefMetadataProvider;
import com.atlassian.stash.internal.build.status.rest.RestBuildStats;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class BuildStatusRefMetadataProvider
implements RefMetadataProvider<RestBuildStats> {
    private final DmzBuildStatusService service;

    public BuildStatusRefMetadataProvider(DmzBuildStatusService service) {
        this.service = service;
    }

    @Nonnull
    public Map<Ref, RestBuildStats> getMetadata(@Nonnull RefMetadataContext context) {
        try {
            return this.service.getSummaries(context.getRepository(), (Collection)context.getRefs()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new RestBuildStats((BuildSummary)entry.getValue())));
        }
        catch (AuthorisationException ex) {
            return Collections.emptyMap();
        }
    }
}

