define('bitbucket-plugin-build/internal/feature/build/pull-request-list/build-status-pull-request-list', ['module', 'exports', 'bitbucket/util/navbuilder', 'bitbucket/util/state', '../common/build-status-common'], function (module, exports, _navbuilder, _state, _buildStatusCommon) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var buildColumn = 'table td.build-status-pr-list-col-value';
    var buildColumnHeader = 'table th.build-status-pr-list-col';

    var columnRenderer = new _buildStatusCommon.BuildStatusColumnRenderer(buildColumnHeader, buildColumn);

    exports.default = {
        renderPlaceholder: function renderPlaceholder(ctx) {
            var prId = ctx.pullRequest.id;
            var link = nav.pullRequest(ctx.pullRequest).builds().build();
            var urlRepo = _state2.default.getRepository();

            if (urlRepo) {
                var _getStats = function _getStats(pullRequestIds) {
                    return (0, _buildStatusCommon.getStatsByPRsAndRepo)(pullRequestIds, urlRepo);
                };

                return columnRenderer.renderPlaceholder(prId, _getStats, link, Date.now(), false);
            }

            var repo = ctx.pullRequest.toRef.repository;
            var getStats = function getStats(pullRequestIds) {
                return (0, _buildStatusCommon.getStatsByPRsAndRepo)(pullRequestIds, repo);
            };

            return columnRenderer.renderPlaceholder(prId, getStats, link, Date.now(), true);
        }
    };
    module.exports = exports['default'];
});