/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.stash.internal.build.requiredbuilds.dao.AoRequiredBuildCondition;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoRequiredBuildConditionUpgradeTaskV0ToV1
implements ActiveObjectsUpgradeTask {
    private static final String INVALID_DEVELOPMENT_ID = "DEVELOPMENT";
    private static final String INVALID_PRODUCTION_ID = "PRODUCTION";
    private static final String MODEL_BRANCH_TYPE = "MODEL_BRANCH";
    private static final String VALID_DEVELOPMENT_ID = "development";
    private static final String VALID_PRODUCTION_ID = "production";
    private static final Logger log = LoggerFactory.getLogger(AoRequiredBuildConditionUpgradeTaskV0ToV1.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This upgrade task can only upgrade from version 0 to 1");
        log.info("Migrating {} from version 0 to version 1.", (Object)"REQUIRED_BUILDS");
        ao.migrate(new Class[]{AoRequiredBuildCondition.class});
        Query query = Query.select((String)"ID").where("EXEMPT_MATCHER_TYPE = ? OR REF_MATCHER_TYPE = ?", new Object[]{MODEL_BRANCH_TYPE, MODEL_BRANCH_TYPE});
        ao.executeInTransaction(() -> {
            ao.stream(AoRequiredBuildCondition.class, query, condition -> {
                long id = condition.getId();
                if (MODEL_BRANCH_TYPE.equals((condition = (AoRequiredBuildCondition)ao.get(AoRequiredBuildCondition.class, (Object)id)).getExemptMatcherType())) {
                    log.trace("Migrating exemption matcher ID for condition[id={}].", (Object)id);
                    if (!AoRequiredBuildConditionUpgradeTaskV0ToV1.migrateMatcherId(id, condition.getExemptMatcherId(), condition::setExemptMatcherId)) {
                        log.warn("Unexpected exemption MODEL_BRANCH matcher ID \"{}\" for condition[id={}] in repository[id={}].", new Object[]{condition.getExemptMatcherId(), condition.getId(), condition.getRepositoryId()});
                    }
                }
                if (MODEL_BRANCH_TYPE.equals(condition.getRefMatcherType())) {
                    log.trace("Migrating protected matcher ID for condition[id={}].", (Object)id);
                    if (!AoRequiredBuildConditionUpgradeTaskV0ToV1.migrateMatcherId(id, condition.getRefMatcherId(), condition::setRefMatcherId)) {
                        log.warn("Unexpected protected MODEL_BRANCH matcher ID \"{}\" for condition[id={}] in repository[id={}].", new Object[]{condition.getRefMatcherId(), condition.getId(), condition.getRepositoryId()});
                    }
                }
                condition.save();
            });
            return null;
        });
        log.info("{} migration to version {} complete.", (Object)"REQUIRED_BUILDS", (Object)this.getModelVersion());
    }

    private static boolean migrateMatcherId(long id, String matcherId, Consumer<String> migration) {
        if (INVALID_DEVELOPMENT_ID.equals(matcherId)) {
            migration.accept(VALID_DEVELOPMENT_ID);
            log.trace("Migrated condition[id={}] matcher ID from {} to {}.", new Object[]{id, INVALID_DEVELOPMENT_ID, VALID_DEVELOPMENT_ID});
            return true;
        }
        if (INVALID_PRODUCTION_ID.equals(matcherId)) {
            migration.accept(VALID_PRODUCTION_ID);
            log.trace("Migrated condition[id={}] matcher ID from {} to {}.", new Object[]{id, INVALID_PRODUCTION_ID, VALID_PRODUCTION_ID});
            return true;
        }
        if (VALID_DEVELOPMENT_ID.equals(matcherId) || VALID_PRODUCTION_ID.equals(matcherId)) {
            log.trace("Skipping migration of condition[id={}] matcher ID since it is already valid.", (Object)id);
            return true;
        }
        log.trace("Skipping migration of condition[id={}] with unexpected matcher ID \"{}\".", (Object)id, (Object)matcherId);
        return false;
    }
}

