/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.dao;

import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.stash.internal.build.requiredbuilds.RefMatcherResolver;
import com.atlassian.stash.internal.build.requiredbuilds.dao.AoBuildParentKey;
import com.atlassian.stash.internal.build.requiredbuilds.dao.AoRequiredBuildCondition;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PartialAoRequiredBuildCondition {
    private final AoRequiredBuildCondition delegate;
    private Set<String> buildParentKeys;
    private RefMatcher refMatcher;
    private RefMatcher exemptRefMatcher;
    private Scope scope;

    public PartialAoRequiredBuildCondition(AoRequiredBuildCondition delegate) {
        this.delegate = delegate;
    }

    public Set<String> getBuildParentKeys() {
        return this.buildParentKeys;
    }

    public RefMatcher getRefMatcher() {
        return this.refMatcher;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Optional<RefMatcher> getExemptRefMatcher() {
        return Optional.ofNullable(this.exemptRefMatcher);
    }

    public void initialize(RefMatcherResolver refMatcherResolver, Scope scope) {
        this.buildParentKeys = Arrays.stream(this.delegate.getAoBuildParentKeys()).map(AoBuildParentKey::getParentKey).collect(Collectors.toSet());
        this.scope = scope;
        this.refMatcher = refMatcherResolver.resolve(this.delegate.getRefMatcherType(), this.delegate.getRefMatcherId(), scope);
        if (this.delegate.getExemptMatcherType() != null && this.delegate.getExemptMatcherId() != null) {
            this.exemptRefMatcher = refMatcherResolver.resolve(this.delegate.getExemptMatcherType(), this.delegate.getExemptMatcherId(), scope);
        }
    }
}

