/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.build.requiredbuilds.RequiredBuildConditionSetRequest;
import com.atlassian.stash.internal.build.requiredbuilds.dao.AoBuildParentKey;
import com.atlassian.stash.internal.build.requiredbuilds.dao.AoRequiredBuildCondition;
import com.atlassian.stash.internal.build.requiredbuilds.dao.InternalRequiredBuildCondition;
import com.atlassian.stash.internal.build.requiredbuilds.dao.RequiredBuildConditionDao;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AoRequiredBuildConditionDao
extends AbstractAoDao
implements RequiredBuildConditionDao {
    private static final Logger log = LoggerFactory.getLogger(AoRequiredBuildConditionDao.class);
    private static final String ID_QUERY = "REPOSITORY_ID = ? AND ID = ?";

    public AoRequiredBuildConditionDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public InternalRequiredBuildCondition add(int repositoryId, @Nonnull RequiredBuildConditionSetRequest setRequest) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"REF_MATCHER_VALUE", (Object)setRequest.getRefMatcher().getId()).put((Object)"REF_MATCHER_TYPE", (Object)setRequest.getRefMatcher().getType().getId()).put((Object)"REPOSITORY_ID", (Object)repositoryId);
        setRequest.getExemptRefMatcher().map(exemptRefMatcher -> builder.put((Object)"EXEMPT_MATCHER_VALUE", (Object)exemptRefMatcher.getId()).put((Object)"EXEMPT_MATCHER_TYPE", (Object)exemptRefMatcher.getType().getId()));
        AoRequiredBuildCondition aoMergeCheck = (AoRequiredBuildCondition)this.ao.create(AoRequiredBuildCondition.class, (Map)builder.build());
        this.addBuildParentKeys(setRequest.getBuildParentKeys(), aoMergeCheck.getId());
        return (InternalRequiredBuildCondition)this.ao.get(AoRequiredBuildCondition.class, (Object)aoMergeCheck.getId());
    }

    @Override
    public void delete(@Nonnull InternalRequiredBuildCondition mergeCheck) {
        this.deleteBuildParentKeys(mergeCheck.getId());
        this.ao.delete(new RawEntity[]{(AoRequiredBuildCondition)mergeCheck});
    }

    @Override
    @Nonnull
    public Optional<InternalRequiredBuildCondition> getById(int repositoryId, long mergeCheckId) {
        AoRequiredBuildCondition[] results = (AoRequiredBuildCondition[])this.ao.find(AoRequiredBuildCondition.class, ID_QUERY, new Object[]{repositoryId, mergeCheckId});
        if (results.length > 1) {
            log.warn("Multiple merge checks found for key {}", (Object)mergeCheckId);
        }
        return Arrays.stream(results).findFirst().map(mergeCheck -> mergeCheck);
    }

    @Override
    @Nonnull
    public Page<InternalRequiredBuildCondition> find(int repositoryId, @Nonnull PageRequest pageRequest) {
        Query searchQuery = Query.select().where("REPOSITORY_ID = ?", new Object[]{repositoryId}).order("ID");
        return PageUtils.asPageOf(InternalRequiredBuildCondition.class, (Page)this.pageQuery(AoRequiredBuildCondition.class, searchQuery, pageRequest));
    }

    @Override
    public InternalRequiredBuildCondition update(@Nonnull RequiredBuildConditionSetRequest setRequest, @Nonnull InternalRequiredBuildCondition mergeCheck) {
        AoRequiredBuildCondition existing = (AoRequiredBuildCondition)mergeCheck;
        existing.setRefMatcherId(setRequest.getRefMatcher().getId());
        existing.setRefMatcherType(setRequest.getRefMatcher().getType().getId());
        if (setRequest.getExemptRefMatcher().isPresent()) {
            RefMatcher exemptRefMatcher = setRequest.getExemptRefMatcher().get();
            existing.setExemptMatcherId(exemptRefMatcher.getId());
            existing.setExemptMatcherType(exemptRefMatcher.getType().getId());
        } else {
            existing.setExemptMatcherId(null);
            existing.setExemptMatcherType(null);
        }
        this.deleteBuildParentKeys(mergeCheck.getId());
        existing.save();
        this.addBuildParentKeys(setRequest.getBuildParentKeys(), existing.getId());
        return (InternalRequiredBuildCondition)this.ao.get(AoRequiredBuildCondition.class, (Object)existing.getId());
    }

    private void addBuildParentKeys(@Nonnull Set<String> buildParentKeys, long mergeCheckId) {
        buildParentKeys.forEach(buildParentKey -> this.ao.create(AoBuildParentKey.class, (Map)ImmutableMap.builder().put((Object)"FK_REQUIRED_BUILD_ID", (Object)mergeCheckId).put((Object)"PARENT_KEY", buildParentKey).build()));
    }

    private void deleteBuildParentKeys(long mergeCheckId) {
        this.ao.deleteWithSQL(AoBuildParentKey.class, "FK_REQUIRED_BUILD_ID = ?", new Object[]{mergeCheckId});
    }
}

