/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.build.requiredbuilds.RefMatcherResolver;
import com.atlassian.stash.internal.build.requiredbuilds.RequiredBuildConditionSetRequest;
import com.atlassian.stash.internal.build.requiredbuilds.RequiredBuildsService;
import com.atlassian.stash.internal.build.requiredbuilds.dao.InternalRequiredBuildCondition;
import com.atlassian.stash.internal.build.requiredbuilds.dao.RequiredBuildConditionDao;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildConditionCreatedEvent;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildConditionDeletedEvent;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildConditionUpdatedEvent;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildsPullRequestDeclinedEvent;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildsPullRequestMergedEvent;
import com.atlassian.stash.internal.build.requiredbuilds.event.RequiredBuildsPullRequestOpenedEvent;
import com.atlassian.stash.internal.build.requiredbuilds.model.RequiredBuildCondition;
import com.atlassian.stash.internal.build.requiredbuilds.model.SimpleRequiredBuildCondition;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class DefaultRequiredBuildsService
implements RequiredBuildsService {
    private static final int DEFAULT_CONDITION_PAGE_SIZE = 20;
    private final RequiredBuildConditionDao dao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final RefMatcherResolver refMatcherResolver;
    private final TransactionTemplate transactionTemplate;

    public DefaultRequiredBuildsService(I18nService i18nService, EventPublisher eventPublisher, PermissionValidationService permissionValidationService, RequiredBuildConditionDao dao, RefMatcherResolver refMatcherResolver, TransactionTemplate transactionTemplate) {
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.refMatcherResolver = refMatcherResolver;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    @Nonnull
    public RequiredBuildCondition createCondition(@Nonnull Scope scope, @Nonnull RequiredBuildConditionSetRequest createRequest) {
        this.validateAdminPermission(scope);
        this.validateSetRequest(createRequest);
        RequiredBuildCondition condition = this.convertCondition((InternalRequiredBuildCondition)this.transactionTemplate.execute(() -> this.dao.add(DefaultRequiredBuildsService.getResourceId(scope), createRequest)), scope);
        this.eventPublisher.publish((Object)new RequiredBuildConditionCreatedEvent(this, condition));
        return condition;
    }

    @Override
    public void deleteCondition(@Nonnull Scope scope, long conditionId) {
        this.validateAdminPermission(scope);
        this.transactionTemplate.execute(() -> {
            this.dao.getById(DefaultRequiredBuildsService.getResourceId(scope), conditionId).ifPresent(condition -> {
                RequiredBuildCondition convertedCheck = this.convertCondition((InternalRequiredBuildCondition)condition, scope);
                this.dao.delete((InternalRequiredBuildCondition)condition);
                this.eventPublisher.publish((Object)new RequiredBuildConditionDeletedEvent(this, convertedCheck));
            });
            return null;
        });
    }

    @Override
    @Nonnull
    public Page<RequiredBuildCondition> getConditions(@Nonnull Scope scope, @Nonnull PageRequest pageRequest) {
        this.validateReadPermission(scope);
        return this.dao.find(DefaultRequiredBuildsService.getResourceId(scope), pageRequest).transform(condition -> this.convertCondition((InternalRequiredBuildCondition)condition, scope));
    }

    @Override
    @Nonnull
    public List<RequiredBuildCondition> getConditionsFor(@Nonnull PullRequest pullRequest) {
        RepositoryScope repoScope = Scopes.repository((Repository)pullRequest.getToRef().getRepository());
        return PageUtils.toStream(arg_0 -> this.lambda$getConditionsFor$4((Scope)repoScope, arg_0), (int)20).filter(mergeCheck -> mergeCheck.getExemptRefMatcher().map(exemptMatcher -> !exemptMatcher.matches((MinimalRef)pullRequest.getFromRef())).orElse(true)).filter(mergeCheck -> mergeCheck.getRefMatcher().matches((MinimalRef)pullRequest.getToRef())).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public RequiredBuildCondition updateCondition(@Nonnull Scope scope, long conditionId, @Nonnull RequiredBuildConditionSetRequest updateRequest) {
        this.validateAdminPermission(scope);
        this.validateSetRequest(updateRequest);
        return (RequiredBuildCondition)this.transactionTemplate.execute(() -> {
            InternalRequiredBuildCondition oldCondition = this.dao.getById(DefaultRequiredBuildsService.getResourceId(scope), conditionId).orElseThrow(() -> new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.build.requiredbuilds.error.invalid.id", new Object[]{scope, conditionId})));
            RequiredBuildCondition convertedOldCondition = this.convertCondition(oldCondition, scope);
            RequiredBuildCondition newCondition = this.convertCondition(this.dao.update(updateRequest, oldCondition), scope);
            this.eventPublisher.publish((Object)new RequiredBuildConditionUpdatedEvent(this, newCondition, convertedOldCondition));
            return newCondition;
        });
    }

    @EventListener
    public void onPullRequestDeclined(PullRequestDeclinedEvent pullRequestDeclinedEvent) {
        PullRequest pullRequest = pullRequestDeclinedEvent.getPullRequest();
        List<RequiredBuildCondition> conditions = this.getConditionsFor(pullRequest);
        if (!conditions.isEmpty()) {
            this.eventPublisher.publish((Object)new RequiredBuildsPullRequestDeclinedEvent(this, pullRequest, conditions.size()));
        }
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent pullRequestMergedEvent) {
        PullRequest pullRequest = pullRequestMergedEvent.getPullRequest();
        List<RequiredBuildCondition> conditions = this.getConditionsFor(pullRequest);
        if (!conditions.isEmpty()) {
            this.eventPublisher.publish((Object)new RequiredBuildsPullRequestMergedEvent(this, pullRequest, conditions.size()));
        }
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent pullRequestOpenedEvent) {
        PullRequest pullRequest = pullRequestOpenedEvent.getPullRequest();
        List<RequiredBuildCondition> conditions = this.getConditionsFor(pullRequest);
        if (!conditions.isEmpty()) {
            this.eventPublisher.publish((Object)new RequiredBuildsPullRequestOpenedEvent(this, pullRequest, conditions.size()));
        }
    }

    private static Integer getResourceId(Scope scope) {
        return (Integer)scope.getResourceId().orElseThrow(() -> new IllegalStateException("Repository scope must have a resource ID"));
    }

    private RequiredBuildCondition convertCondition(InternalRequiredBuildCondition condition, Scope resolutionScope) {
        condition.initialize(this.refMatcherResolver, resolutionScope);
        SimpleRequiredBuildCondition.Builder builder = new SimpleRequiredBuildCondition.Builder(condition.getId(), condition.getBuildParentKeys(), condition.getRefMatcher(), resolutionScope);
        condition.getExemptRefMatcher().ifPresent(builder::exemptRefMatcher);
        return builder.build();
    }

    private void validateAdminPermission(Scope scope) {
        this.validateScopeType(scope);
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultRequiredBuildsService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateReadPermission(Scope scope) {
        this.validateScopeType(scope);
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultRequiredBuildsService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_READ);
                return null;
            }
        });
    }

    private void validateScopeType(Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() != ScopeType.REPOSITORY) {
            throw new UnsupportedOperationException(String.format("Required builds cannot be managed at a %s level scope.", scope.getType()));
        }
    }

    private void validateSetRequest(RequiredBuildConditionSetRequest request) {
        if (request.getBuildParentKeys().isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.build.requiredbuilds.error.invalid.parentkeys", new Object[0]));
        }
    }

    private /* synthetic */ Page lambda$getConditionsFor$4(Scope repoScope, PageRequest pageRequest) {
        return this.getConditions(repoScope, pageRequest);
    }
}

