/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.property;

import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimplePropertySupport
implements PropertySupport {
    private transient PropertyMap properties;

    public SimplePropertySupport(@Nonnull AbstractPropertyBuilder<?> builder) {
        this.properties = builder.properties.build();
    }

    @Override
    @Nonnull
    public PropertyMap getProperties() {
        return this.properties;
    }

    public void setProperties(@Nonnull PropertyMap properties) {
        Objects.requireNonNull(properties, "properties");
        PropertyMap.Builder builder = new PropertyMap.Builder();
        if (this.properties != null && !this.properties.isEmpty()) {
            builder.properties(this.properties);
        }
        this.properties = builder.properties(properties).build();
    }

    public static abstract class AbstractPropertyBuilder<B extends AbstractPropertyBuilder<B>>
    extends BuilderSupport {
        protected final PropertyMap.Builder properties = new PropertyMap.Builder();

        protected AbstractPropertyBuilder() {
        }

        protected AbstractPropertyBuilder(@Nonnull PropertySupport entity) {
            this.properties(Objects.requireNonNull(entity, "entity").getProperties());
        }

        @Nonnull
        public B property(@Nonnull String key, @Nonnull Object value) {
            this.properties.property(key, value);
            return this.self();
        }

        @Nonnull
        public B properties(@Nonnull Map<String, Object> other) {
            this.properties.properties(other);
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

