/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class HookScriptSetConfigurationRequest {
    private final Scope scope;
    private final HookScript script;
    private final Set<String> triggerIds;

    private HookScriptSetConfigurationRequest(Builder builder) {
        this.scope = builder.scope;
        this.script = builder.script;
        this.triggerIds = builder.triggerIds.build();
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nonnull
    public HookScript getScript() {
        return this.script;
    }

    @Nonnull
    public Set<String> getTriggerIds() {
        return this.triggerIds;
    }

    public static class Builder
    extends BuilderSupport {
        private final Scope scope;
        private final HookScript script;
        private final ImmutableSet.Builder<String> triggerIds;

        public Builder(@Nonnull HookScript script, @Nonnull Scope scope) {
            this.script = Objects.requireNonNull(script, "script");
            this.scope = Objects.requireNonNull(scope, "scope");
            this.triggerIds = ImmutableSet.builder();
        }

        @Nonnull
        public HookScriptSetConfigurationRequest build() {
            return new HookScriptSetConfigurationRequest(this);
        }

        @Nonnull
        public Builder triggerId(@Nonnull String value) {
            this.triggerIds.add((Object)Builder.requireNonBlank(value, "triggerId"));
            return this;
        }

        @Nonnull
        public Builder triggerIds(@Nonnull Iterable<String> values) {
            Objects.requireNonNull(values, "triggerIds").forEach(this::triggerId);
            return this;
        }

        @Nonnull
        public Builder triggerIds(@Nonnull String value, String ... values) {
            return this.triggerId(value).triggerIds(Arrays.asList(Objects.requireNonNull(values, "triggerIds")));
        }

        @Nonnull
        public Builder trigger(@Nonnull RepositoryHookTrigger trigger) {
            return this.triggerId(Objects.requireNonNull(trigger, "trigger").getId());
        }

        @Nonnull
        public Builder triggers(@Nonnull Iterable<RepositoryHookTrigger> values) {
            Objects.requireNonNull(values, "triggers").forEach(this::trigger);
            return this;
        }

        @Nonnull
        public Builder triggers(@Nonnull RepositoryHookTrigger value, RepositoryHookTrigger ... values) {
            return this.trigger(value).triggers(Arrays.asList(Objects.requireNonNull(values, "triggers")));
        }
    }
}

