/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public abstract class AbstractRepositoryHookRequest
implements RepositoryHookRequest {
    private final Map<String, Object> context;
    private final boolean dryRun;
    private final Repository repository;
    private final RepositoryHookTrigger trigger;

    protected AbstractRepositoryHookRequest(AbstractBuilder<?> builder) {
        this.context = builder.context.build();
        this.dryRun = builder.dryRun;
        this.repository = builder.repository;
        this.trigger = builder.trigger;
    }

    @Override
    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    @Nonnull
    public Optional<ScmHookDetails> getScmHookDetails() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public RepositoryHookTrigger getTrigger() {
        return this.trigger;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends BuilderSupport {
        private final ImmutableMap.Builder<String, Object> context;
        private final Repository repository;
        private final RepositoryHookTrigger trigger;
        private boolean dryRun;

        protected AbstractBuilder(@Nonnull Repository repository, @Nonnull RepositoryHookTrigger trigger) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.trigger = Objects.requireNonNull(trigger, "trigger");
            this.context = ImmutableMap.builder();
        }

        @Nonnull
        public B context(@Nonnull String key, @Nonnull String value) {
            this.context.put((Object)Objects.requireNonNull(key, "key"), (Object)Objects.requireNonNull(value, "value"));
            return this.self();
        }

        @Nonnull
        public B context(@Nonnull Map<String, Object> value) {
            this.context.putAll(Objects.requireNonNull(value, "context"));
            return this.self();
        }

        @Nonnull
        public B dryRun(boolean value) {
            this.dryRun = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

