/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server;

import com.atlassian.bitbucket.server.Feature;
import javax.annotation.Nonnull;

public enum StandardFeature implements Feature
{
    ATTACHMENTS("attachments"),
    AUTH_CAPTCHA("auth.captcha"),
    BIDI_CHARACTER_HIGHLIGHTING("bidi.character.highlighting"),
    CODE_OWNERS("code.owners"),
    COMMIT_GRAPH("commit.graph"),
    COMMIT_SHOW_SIGNATURES("commit.show.signatures"),
    DIAGNOSTICS("diagnostics"),
    DEPLOYMENTS("deployments"),
    ENFORCE_PASSWORD_USER_EMAIL_UPDATE("enforce.password.user.email.update"),
    FILE_EDITOR("file.editor"),
    FORKS("forks"),
    GETTING_STARTED("getting.started.page"),
    DATA_CENTER_MIGRATION_EXPORT("data.center.migration.export"),
    DATA_CENTER_MIGRATION_IMPORT("data.center.migration.import"),
    ENFORCE_PROJECT_SETTINGS("enforce.project.settings"),
    HOOK_SCRIPTS("hook.scripts"),
    JIRA_CLOUD_DEV_INFO("jira.cloud.devinfo"),
    JIRA_COMMIT_CHECKER("jira.commit.checker"),
    PERSONAL_REPOS("personal.repos"),
    PROJECT_REPO_ACCESS_TOKENS("project.repo.access.tokens"),
    PUBLIC_ACCESS("public.access"),
    PULL_REQUEST_AUTO_DECLINE("pull.request.auto.decline"),
    PULL_REQUEST_AUTO_MERGE("pull.request.auto.merge"),
    PULL_REQUEST_DELETION("pull.request.deletion"),
    PULL_REQUEST_DRAFTS("pull.request.drafts"),
    PULL_REQUEST_SUGGESTIONS("pull.request.suggestions"),
    PULL_REQUEST_TEMPLATES("pull.request.templates"),
    RATE_LIMITING("rate.limiting"),
    REPOSITORY_ARCHIVING("repository.archiving"),
    REPOSITORY_DELETE_POLICY("repository.delete.policy"),
    REPOSITORY_MANAGEMENT("repository.management"),
    REQUIRED_BUILDS("required.builds"),
    REVIEWER_GROUPS("reviewer.groups"),
    ROLLING_UPGRADE("rolling.upgrade"),
    SECRET_SCANNING("secret.scanning"),
    SYSTEM_SIGNED_GIT_OBJECTS("system.signed.git.objects"),
    SMART_MIRRORS("smart.mirrors"),
    SSH_KEYS_FOR_CODE_SIGNING("ssh.keys.for.code.signing"),
    SUGGEST_REVIEWERS("suggest.reviewers"),
    TIME_ZONE_ONBOARDING("user.time.zone.onboarding"),
    WEB_SUDO("websudo"),
    WHATS_NEW("whats.new"),
    X509_CERTIFICATE_SIGNING("x509.certificate.signing");

    private final String key;

    private StandardFeature(String key) {
        this.key = key;
    }

    @Nonnull
    public static StandardFeature fromKey(String value) {
        for (StandardFeature feature : StandardFeature.values()) {
            if (!feature.getKey().equals(value)) continue;
            return feature;
        }
        throw new IllegalArgumentException("No Feature is associated with key [" + value + "]");
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }
}

