/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestParticipantRequest {
    private final PullRequestRole role;
    private final Set<PullRequestParticipantStatus> statuses;
    private final String username;

    private PullRequestParticipantRequest(Builder builder) {
        this.statuses = ImmutableSet.copyOf(builder.statuses);
        this.role = builder.role;
        this.username = builder.username;
    }

    @Nullable
    public PullRequestRole getRole() {
        return this.role;
    }

    @Nonnull
    public Set<PullRequestParticipantStatus> getStatuses() {
        return this.statuses;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public static class Builder
    extends BuilderSupport {
        private final EnumSet<PullRequestParticipantStatus> statuses;
        private final String username;
        private PullRequestRole role;

        public Builder(@Nonnull String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.statuses = EnumSet.noneOf(PullRequestParticipantStatus.class);
        }

        @Nonnull
        public PullRequestParticipantRequest build() {
            return new PullRequestParticipantRequest(this);
        }

        @Nonnull
        public Builder role(@Nullable PullRequestRole value) {
            this.role = value;
            return this;
        }

        @Nonnull
        public Builder status(@Nullable PullRequestParticipantStatus value) {
            Builder.addIf(Objects::nonNull, this.statuses, value);
            return this;
        }

        @Nonnull
        public Builder statuses(@Nonnull Iterable<PullRequestParticipantStatus> values) {
            Builder.addIf(Objects::nonNull, this.statuses, values);
            return this;
        }
    }
}

