/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVeto;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RepositoryHookVetoedException
extends ServiceException {
    private final RepositoryHookRequest request;
    private final List<RepositoryHookVeto> vetoes;

    public RepositoryHookVetoedException(@Nonnull KeyedMessage message, @Nonnull RepositoryHookRequest request, @Nonnull List<RepositoryHookVeto> vetoes) {
        super(message);
        Preconditions.checkArgument((!Objects.requireNonNull(vetoes, "vetoes").isEmpty() ? 1 : 0) != 0, (Object)"At least one veto must be provided");
        this.request = Objects.requireNonNull(request, "request");
        this.vetoes = vetoes;
    }

    @Nonnull
    public <T extends RepositoryHookRequest> T getRequest() {
        return (T)this.request;
    }

    @Nonnull
    public List<RepositoryHookVeto> getVetoes() {
        return this.vetoes;
    }
}

