/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.filestore;

import com.atlassian.bitbucket.filestore.FilePath;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeleteFilesRequest {
    private final Set<FilePath> delete;
    private final String namespace;

    private DeleteFilesRequest(@Nonnull Builder builder) {
        this.delete = builder.delete;
        this.namespace = builder.namespace;
    }

    @Nonnull
    public Set<FilePath> getDelete() {
        return Set.copyOf(this.delete);
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public static class Builder
    extends BuilderSupport {
        private String namespace;
        private final Set<FilePath> delete = new HashSet<FilePath>();

        @Nonnull
        public DeleteFilesRequest build() {
            return new DeleteFilesRequest(this);
        }

        @Nonnull
        public Builder delete(@Nullable Collection<FilePath> value) {
            Builder.addIf(Objects::nonNull, this.delete, value);
            return this;
        }

        @Nonnull
        public Builder delete(@Nullable FilePath value) {
            Builder.addIf(Objects::nonNull, this.delete, value);
            return this;
        }

        @Nonnull
        public Builder namespace(@Nonnull String value) {
            this.namespace = Builder.requireNonBlank(value, "namespace");
            return this;
        }
    }
}

