/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dashboard;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SuggestPullRequestsRequest {
    public static final int DEFAULT_LIMIT = 5;
    private final Date changesSince;
    private final int limit;
    private final ApplicationUser user;

    private SuggestPullRequestsRequest(Builder builder) {
        this.changesSince = builder.changesSince;
        this.limit = builder.limit;
        this.user = builder.user;
    }

    @Nonnull
    public Date getChangesSince() {
        return this.changesSince;
    }

    public int getLimit() {
        return this.limit;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder
    extends BuilderSupport {
        private final Date changesSince;
        private final ApplicationUser user;
        private int limit;

        public Builder(@Nonnull ApplicationUser user, @Nonnull Date changesSince) {
            this.user = Objects.requireNonNull(user, "user");
            this.changesSince = Objects.requireNonNull(changesSince, "changesSince");
            this.limit = 5;
        }

        @Nonnull
        public SuggestPullRequestsRequest build() {
            return new SuggestPullRequestsRequest(this);
        }

        @Nonnull
        public Builder limit(int value) {
            this.limit = value;
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

