/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.CommitListMergeFilter;
import com.atlassian.bitbucket.commit.CommitOrder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCommitsRequest {
    public static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final boolean followRenames;
    private final boolean ignoringMissing;
    private final int maxMessageLength;
    private final CommitListMergeFilter merges;
    private final CommitOrder order;
    private final Set<String> paths;
    private final Set<String> propertyKeys;
    private final Repository repository;

    protected AbstractCommitsRequest(AbstractCommitsRequestBuilder<?> builder) {
        this.followRenames = builder.followRenames;
        this.ignoringMissing = builder.ignoringMissing;
        this.maxMessageLength = builder.maxMessageLength;
        this.merges = builder.merges;
        this.order = builder.order;
        this.paths = builder.paths.build();
        this.propertyKeys = builder.propertyKeys.build();
        this.repository = builder.repository;
        if (this.followRenames) {
            if (this.paths.isEmpty()) {
                throw new IllegalStateException("A path must be supplied when attempting to follow renames");
            }
            if (this.paths.size() > 1) {
                throw new IllegalStateException("Following renames is only possible with a single path");
            }
        }
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nonnull
    public CommitListMergeFilter getMerges() {
        return this.merges;
    }

    @Nonnull
    public CommitOrder getOrder() {
        return this.order;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.propertyKeys;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public boolean isFollowingRenames() {
        return this.followRenames;
    }

    public boolean isIgnoringMissing() {
        return this.ignoringMissing;
    }

    public static abstract class AbstractCommitsRequestBuilder<B extends AbstractCommitsRequestBuilder<B>>
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> paths;
        private final ImmutableSet.Builder<String> propertyKeys;
        private final Repository repository;
        private boolean followRenames;
        private boolean ignoringMissing;
        private int maxMessageLength;
        private CommitListMergeFilter merges;
        private CommitOrder order;

        protected AbstractCommitsRequestBuilder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.maxMessageLength = -1;
            this.merges = CommitListMergeFilter.INCLUDE;
            this.order = CommitOrder.DEFAULT;
            this.paths = ImmutableSet.builder();
            this.propertyKeys = ImmutableSet.builder();
        }

        protected AbstractCommitsRequestBuilder(@Nonnull AbstractCommitsRequest request) {
            this(Objects.requireNonNull(request, "request").getRepository());
            ((AbstractCommitsRequestBuilder)((AbstractCommitsRequestBuilder)((AbstractCommitsRequestBuilder)((AbstractCommitsRequestBuilder)((AbstractCommitsRequestBuilder)this.followRenames(request.isFollowingRenames())).ignoreMissing(request.isIgnoringMissing())).merges(request.getMerges())).order(request.getOrder())).paths(request.getPaths())).propertyKeys(request.getPropertyKeys());
        }

        @Nonnull
        public B followRenames(boolean value) {
            this.followRenames = value;
            return this.self();
        }

        @Nonnull
        public B ignoreMissing(boolean value) {
            this.ignoringMissing = value;
            return this.self();
        }

        @Nonnull
        public B maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this.self();
        }

        @Nonnull
        public B merges(@Nonnull CommitListMergeFilter value) {
            this.merges = Objects.requireNonNull(value, "merges");
            return this.self();
        }

        @Nonnull
        public B order(@Nonnull CommitOrder value) {
            this.order = Objects.requireNonNull(value, "order");
            return this.self();
        }

        @Nonnull
        public B path(@Nullable String value) {
            AbstractCommitsRequestBuilder.addIf(NOT_BLANK, this.paths, value);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable Iterable<String> values) {
            AbstractCommitsRequestBuilder.addIf(NOT_BLANK, this.paths, values);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable String value, String ... values) {
            AbstractCommitsRequestBuilder.addIf(NOT_BLANK, this.paths, value, values);
            return this.self();
        }

        @Nonnull
        public B propertyKey(@Nullable String value) {
            AbstractCommitsRequestBuilder.addIf(NOT_BLANK, this.propertyKeys, value);
            return this.self();
        }

        @Nonnull
        public B propertyKeys(@Nullable Iterable<String> values) {
            AbstractCommitsRequestBuilder.addIf(NOT_BLANK, this.propertyKeys, values);
            return this.self();
        }

        @Nonnull
        public B propertyKeys(@Nullable String value, String ... values) {
            AbstractCommitsRequestBuilder.addIf(NOT_BLANK, this.propertyKeys, value, values);
            return this.self();
        }

        protected abstract B self();
    }
}

