/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.job;

import javax.annotation.Nonnull;

public enum JobState {
    INITIALISING(100, false, false),
    READY(200, false, false),
    RUNNING(300, false, false),
    FINALISING(400, false, false),
    COMPLETED(500, false, true),
    FAILED(600, true, true),
    CANCELING(650, true, false),
    CANCELED(700, true, true),
    TIMED_OUT(800, true, true),
    ABORTED(900, true, true);

    private final boolean failed;
    private final int id;
    private final boolean terminated;

    private JobState(int id, boolean failed, boolean terminated) {
        this.id = id;
        this.failed = failed;
        this.terminated = terminated;
    }

    @Nonnull
    public static JobState fromId(int id) {
        for (JobState value : JobState.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No JobState is associated with ID [" + id + "]");
    }

    public int getId() {
        return this.id;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

