/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
public class PullRequestMergedEvent
extends PullRequestEvent
implements RepositoryRefsChangedEvent {
    private final boolean autoMerge;
    private final MinimalCommit commit;
    private final String message;
    private final Collection<RefChange> refChanges;
    private final String strategyId;

    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest) {
        this(source, pullRequest, null, null, null, false);
    }

    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable MinimalCommit commit, @Nullable String message) {
        this(source, pullRequest, commit, message, null, false);
    }

    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable MinimalCommit commit, @Nullable String message, @Nullable String strategyId, boolean autoMerge) {
        super(source, pullRequest, PullRequestAction.MERGED);
        this.autoMerge = autoMerge;
        this.commit = commit;
        this.message = message;
        this.strategyId = strategyId;
        this.refChanges = commit == null ? Collections.emptyList() : Collections.singleton(((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().from(pullRequest.getToRef())).toHash(commit.getId())).type(RefChangeType.UPDATE)).build());
    }

    @Nullable
    public MinimalCommit getCommit() {
        return this.commit;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.getPullRequest().getToRef().getRepository();
    }

    @Nullable
    public String getStrategyId() {
        return this.strategyId;
    }

    public boolean isAutoMerge() {
        return this.autoMerge;
    }

    public boolean isMergedRemotely() {
        return this.commit == null;
    }
}

