/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import javax.annotation.Nonnull;

public class PullRequestCommitsCommandParameters
extends AbstractCommandParameters {
    private final int maxMessageLength;
    private final boolean withMessages;

    private PullRequestCommitsCommandParameters(Builder builder) {
        this.maxMessageLength = builder.withMessages ? Math.max(-1, builder.maxMessageLength) : 0;
        this.withMessages = builder.withMessages && this.maxMessageLength != 0;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public boolean isWithMessages() {
        return this.withMessages;
    }

    public static class Builder {
        private int maxMessageLength = -1;
        private boolean withMessages = true;

        @Nonnull
        public PullRequestCommitsCommandParameters build() {
            return new PullRequestCommitsCommandParameters(this);
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }

        @Nonnull
        public Builder withMessages(boolean value) {
            this.withMessages = value;
            return this;
        }
    }
}

