/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RefOrder {
    ALPHABETICAL,
    MODIFICATION;

    private static final Logger log;

    @Nullable
    public static RefOrder fromValueOrNull(@Nullable String order) {
        RefOrder value = null;
        if (StringUtils.isNotBlank((CharSequence)order)) {
            try {
                value = RefOrder.valueOf(StringUtils.upperCase((String)order, (Locale)Locale.ROOT));
            }
            catch (IllegalArgumentException ignored) {
                log.warn("Defaulting unknown order [{}] to {}", (Object)order, (Object)value);
            }
        }
        return value;
    }

    static {
        log = LoggerFactory.getLogger(RefOrder.class);
    }
}

