package com.atlassian.bitbucket.watcher;

import javax.annotation.Nonnull;

/**
 * @since 5.10
 */
public class WatchRequest extends AbstractWatcherRequest {

    private WatchRequest(@Nonnull AbstractBuilder<?, ?> builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, WatchRequest> {

        public Builder(@Nonnull Watchable watchable) {
            super(watchable);
        }

        @Nonnull
        @Override
        public WatchRequest build() {
            return new WatchRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
