package com.atlassian.bitbucket.validation;

import com.atlassian.bitbucket.validation.annotation.OptionalString;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * Validator for the {@link OptionalString} annotation.
 */
public class OptionalStringValidator implements ConstraintValidator<OptionalString, String> {

    @Override
    public void initialize(OptionalString constraintAnnotation) {
    }

    /**
     * Checks that the trimmed string is not empty.
     *
     * @param s The string to validate.
     * @param constraintValidatorContext context in which the constraint is evaluated.
     *
     * @return Returns <code>true</code> if the string is <code>null</code> or the length of <code>s</code> between the specified
     *         <code>min</code> and <code>max</code> values (inclusive), <code>false</code> otherwise.
     */
    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        return s == null || s.trim().length() > 0;
    }
}
