package com.atlassian.bitbucket.scm;

import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;

public class RawFileCommandParameters extends AbstractCommitCommandParameters {

    private RawFileCommandParameters(Builder builder) {
        super(builder);

        if (StringUtils.isBlank(getCommitId())) {
            throw new IllegalStateException("A commit ID must provided when streaming raw file contents");
        }
        if (StringUtils.isBlank(getPath())) {
            throw new IllegalStateException("A path must be provided when streaming raw file contents");
        }
    }

    public static class Builder extends AbstractCommitParametersBuilder<Builder> {

        public Builder() {
        }

        @Nonnull
        public RawFileCommandParameters build() {
            return new RawFileCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
