package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.commit.Commit;

import javax.annotation.Nonnull;

/**
 * Common abstraction between reference types like {@link Branch branches} and {@link Tag tags}.
 */
public interface Ref extends MinimalRef {

    /**
     * The {@link Commit#getId ID} of the commit at the tip of this ref.
     *
     * @return the tip commit's ID
     */
    @Nonnull
    String getLatestCommit();
}
