package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Map;

/**
 * A map of pluggable metadata associated with a {@link Ref}
 *
 * @see RefService#getMetadataByRefs(RefMetadataRequest)
 */
public interface MetadataMap {

    /**
     * @return return the metadata as an immutable {@code Map}, keyed by complete module key.
     */
    @Nonnull
    Map<String, Object> asMap();

    /**
     * @param completeModuleKey the complete module key of the provider which provided the metadata
     * @return {@code true} if metadata exists for this module key, {@code false} otherwise
     */
    boolean contains(@Nonnull String completeModuleKey);

    /**
     * @param completeModuleKey the complete module key of the provider which provided the metadata
     * @return the associated metadata
     */
    @Nullable
    Object get(@Nonnull String completeModuleKey);

}
