package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;
import java.io.IOException;

/**
 * Convenience implementation of {@link RefCallback} that provides no-op implementations for all methods.
 */
public class AbstractRefCallback implements RefCallback {

    @Override
    public void onEnd(@Nonnull RefSummary summary) throws IOException {
    }

    /**
     * Discards the provided {@link Ref ref}.
     *
     * @param ref ignored
     */
    @Override
    public boolean onRef(@Nonnull Ref ref) throws IOException {
        return true;
    }

    @Override
    public void onStart(@Nonnull RefContext context) throws IOException {
    }
}
