package com.atlassian.bitbucket.pull;

/**
 * Represents the property enriching mode regarding pull requests and pull request activities.
 *
 * @since 7.14
 */
public enum PullRequestActivityPropertyMode {

    /**
     * Applies property enrichment to activities, but not their pull requests.
     */
    ACTIVITY_ONLY(true, false),
    /**
     * Applies property enrichment to activities and their pull requests.
     */
    ALL(true, true),
    /**
     * Disables property enrichment on activities and their pull requests.
     */
    NONE(false, false),
    /**
     * Applies property enrichment to pull requests, but not their activities.
     */
    PULL_REQUEST_ONLY(false, true);

    private final boolean activities;
    private final boolean pullRequests;

    PullRequestActivityPropertyMode(boolean activities, boolean pullRequests) {
        this.activities = activities;
        this.pullRequests = pullRequests;
    }

    /**
     * @return true if the property enrichment process should be applied to pull request activities.
     */
    public boolean includesActivities() {
        return activities;
    }

    /**
     * @return true if the property enrichment process should be applied to pull requests.
     */
    public boolean includesPullRequests() {
        return pullRequests;
    }
}
