package com.atlassian.bitbucket.mail;

import javax.activation.DataSource;
import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public class MailAttachment {

    private final String fileName;
    private final DataSource source;

    @Nonnull
    public MailAttachment(String fileName, DataSource source) {
        this.fileName = requireNonNull(fileName, "fileName");
        this.source = requireNonNull(source, "source");
    }

    @Nonnull
    public String getFileName() {
        return fileName;
    }

    @Nonnull
    public DataSource getSource() {
        return source;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        MailAttachment that = (MailAttachment) o;
        //Cannot check for deep equality on the DataSource, must check for reference equality
        return fileName.equals(that.fileName) && source == that.source;
    }

    @Override
    public int hashCode() {
        int result = fileName.hashCode();
        result = 31 * result + source.hashCode();
        return result;
    }
}
