package com.atlassian.bitbucket.i18n;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * A container object to allow the passing of a property key and its associated context variables.
 * This allows a property to be expanded just-in-time.
 */
public class I18nKey {

    private final Object[] arguments;
    private final String key;

    public I18nKey(@Nonnull String key, @Nonnull Object... arguments) {
        this.key = requireNonNull(key, "key");
        this.arguments = requireNonNull(arguments, "context");
    }

    @Nonnull
    public Object[] getArguments() {
        return arguments;
    }

    @Nonnull
    public String getKey() {
        return key;
    }
}
